/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.buildwrapper;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFile;
import org.jenkinsci.plugins.configfiles.buildwrapper.Messages;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.jenkinsci.plugins.configfiles.maven.security.HasServerCredentialMappings;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class ManagedFileUtil {
    private static final Logger LOGGER = Logger.getLogger(ManagedFileUtil.class.getName());

    public static FilePath tempDir(FilePath ws) {
        return ws.sibling(ws.getName() + System.getProperty(WorkspaceList.class.getName(), "@") + "tmp");
    }

    public static Map<ManagedFile, FilePath> provisionConfigFiles(List<ManagedFile> managedFiles, Run<?, ?> build, FilePath workspace, TaskListener listener, List<String> tempFiles) throws IOException, InterruptedException {
        HashMap<ManagedFile, FilePath> file2Path = new HashMap<ManagedFile, FilePath>();
        listener.getLogger().println("provisoning config files...");
        for (ManagedFile managedFile : managedFiles) {
            FilePath target;
            Object configFile = ConfigFiles.getByIdOrNull(build, managedFile.fileId);
            if (configFile == null) {
                String message = "not able to provide the file " + managedFile + ", can't be resolved by any provider - maybe it got deleted by an administrator?";
                listener.getLogger().println(message);
                throw new AbortException(message);
            }
            FilePath workDir = ManagedFileUtil.tempDir(workspace);
            workDir.mkdirs();
            boolean createTempFile = StringUtils.isBlank((String)managedFile.targetLocation);
            if (createTempFile) {
                target = workDir.createTempFile("config", "tmp");
            } else {
                String expandedTargetLocation = managedFile.targetLocation;
                try {
                    expandedTargetLocation = TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)managedFile.targetLocation);
                }
                catch (MacroEvaluationException e) {
                    listener.getLogger().println("[ERROR] failed to expand variables in target location '" + managedFile.targetLocation + "' : " + e.getMessage());
                    expandedTargetLocation = managedFile.targetLocation;
                }
                target = new FilePath(workspace, expandedTargetLocation);
                String immediateFileName = expandedTargetLocation.substring(expandedTargetLocation.lastIndexOf("/") + 1);
                if (immediateFileName.length() == 0 || target.exists() && target.isDirectory()) {
                    target = new FilePath(target, ((Config)configFile).name.replace(" ", "_"));
                }
            }
            String fileContent = ManagedFileUtil.insertCredentialsInSettings(build, configFile, workDir, tempFiles);
            if (managedFile.getReplaceTokens().booleanValue()) {
                try {
                    fileContent = TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)fileContent);
                }
                catch (MacroEvaluationException e) {
                    listener.getLogger().println("[ERROR] failed to expand variables in content of " + ((Config)configFile).name + " - " + e.getMessage());
                }
            }
            LOGGER.log(Level.FINE, "Create file {0} for configuration {1} mapped as {2}", new Object[]{target.getRemote(), configFile, managedFile});
            listener.getLogger().println(Messages.console_output(((Config)configFile).name, target.toURI()));
            ByteArrayInputStream bs = new ByteArrayInputStream(fileContent.getBytes("UTF-8"));
            target.copyFrom((InputStream)bs);
            target.chmod(416);
            file2Path.put(managedFile, target);
        }
        return file2Path;
    }

    private static String insertCredentialsInSettings(Run<?, ?> build, Config configFile, FilePath workDir, List<String> tempFiles) throws IOException {
        String fileContent = configFile.content;
        if (configFile instanceof HasServerCredentialMappings) {
            HasServerCredentialMappings settings = (HasServerCredentialMappings)((Object)configFile);
            Map<String, StandardUsernameCredentials> resolvedCredentials = CredentialsHelper.resolveCredentials(build, settings.getServerCredentialMappings());
            Boolean isReplaceAll = settings.getIsReplaceAll();
            if (!resolvedCredentials.isEmpty()) {
                try {
                    fileContent = CredentialsHelper.fillAuthentication(fileContent, isReplaceAll, resolvedCredentials, workDir, tempFiles);
                }
                catch (Exception exception) {
                    throw new IOException("[ERROR] could not insert credentials into the settings file " + configFile, exception);
                }
            }
        }
        return fileContent;
    }
}

