/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.buildwrapper;

import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ManagedFile
implements ExtensionPoint,
Describable<ManagedFile>,
Serializable {
    public final String fileId;
    public String targetLocation;
    public String variable;
    private Boolean replaceTokens;

    @DataBoundConstructor
    public ManagedFile(String fileId) {
        this.fileId = fileId;
    }

    public ManagedFile(String fileId, String targetLocation, String variable, Boolean replaceTokens) {
        this.fileId = fileId;
        this.targetLocation = Util.fixEmpty((String)targetLocation);
        this.variable = Util.fixEmpty((String)variable);
        this.replaceTokens = replaceTokens;
    }

    public ManagedFile(String fileId, String targetLocation, String variable) {
        this.fileId = fileId;
        this.targetLocation = Util.fixEmpty((String)targetLocation);
        this.variable = Util.fixEmpty((String)variable);
        this.replaceTokens = false;
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    @DataBoundSetter
    public void setTargetLocation(String targetLocation) {
        this.targetLocation = Util.fixEmpty((String)targetLocation);
    }

    public String getVariable() {
        return this.variable;
    }

    @DataBoundSetter
    public void setVariable(String variable) {
        this.variable = Util.fixEmpty((String)variable);
    }

    @DataBoundSetter
    public void setReplaceTokens(Boolean replaceTokens) {
        this.replaceTokens = replaceTokens;
    }

    public String toString() {
        return "[ManagedFile: id=" + this.fileId + ", targetLocation=" + this.targetLocation + ", variable=" + this.variable + "]";
    }

    public Boolean getReplaceTokens() {
        return this.replaceTokens != null ? this.replaceTokens : false;
    }

    public Descriptor<ManagedFile> getDescriptor() {
        return (DescriptorImpl)Jenkins.getActiveInstance().getDescriptorOrDie(this.getClass());
    }

    @Symbol(value={"configFile"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ManagedFile> {
        public String getDisplayName() {
            return "";
        }

        public ListBoxModel doFillFileIdItems(@AncestorInPath ItemGroup context) {
            ListBoxModel items = new ListBoxModel();
            items.add("please select", "");
            for (Config config : ConfigFiles.getConfigsInContext(context, null)) {
                items.add(config.name, config.id);
            }
            return items;
        }
    }
}

