/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.security;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.FilePath;
import hudson.model.Run;
import hudson.util.Secret;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.configfiles.maven.security.MavenServerIdRequirement;
import org.jenkinsci.plugins.configfiles.maven.security.ServerCredentialMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CredentialsHelper {
    private static final Logger LOGGER = Logger.getLogger(CredentialsHelper.class.getName());
    private static final Collection<String> ATTRIBUTES_TO_KEEPT = Arrays.asList("filePermissions", "directoryPermissions", "configuration");

    private CredentialsHelper() {
    }

    public static Map<String, StandardUsernameCredentials> resolveCredentials(Run<?, ?> build, List<ServerCredentialMapping> serverCredentialMappings) {
        HashMap<String, StandardUsernameCredentials> serverId2credential = new HashMap<String, StandardUsernameCredentials>();
        for (ServerCredentialMapping serverCredentialMapping : serverCredentialMappings) {
            StandardUsernameCredentials c;
            String credentialsId = serverCredentialMapping.getCredentialsId();
            String serverId = serverCredentialMapping.getServerId();
            List<Object> domainRequirements = Collections.emptyList();
            if (StringUtils.isNotBlank((String)serverId)) {
                domainRequirements = Collections.singletonList(new MavenServerIdRequirement(serverId));
            }
            if ((c = (StandardUsernameCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernameCredentials.class, build, domainRequirements)) == null) continue;
            serverId2credential.put(serverId, c);
        }
        return serverId2credential;
    }

    public static String fillAuthentication(String mavenSettingsContent, Boolean isReplaceAllServerDefinitions, Map<String, StandardUsernameCredentials> mavenServerId2jenkinsCredential, FilePath workDir, List<String> tempFiles) throws Exception {
        String content = mavenSettingsContent;
        if (mavenServerId2jenkinsCredential.isEmpty()) {
            return mavenSettingsContent;
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(content)));
        Map<Object, Object> removedMavenServers = Collections.emptyMap();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node serversNode = (Node)xpath.evaluate("/settings/servers", doc, XPathConstants.NODE);
        if (serversNode == null) {
            Node settingsNode = (Node)xpath.evaluate("/settings", doc, XPathConstants.NODE);
            serversNode = doc.createElement("servers");
            settingsNode.appendChild(serversNode);
        } else {
            removedMavenServers = CredentialsHelper.removeMavenServerDefinitions(serversNode, mavenServerId2jenkinsCredential.keySet(), Boolean.TRUE.equals(isReplaceAllServerDefinitions));
        }
        for (Map.Entry entry : mavenServerId2jenkinsCredential.entrySet()) {
            StandardUsernameCredentials credential = (StandardUsernameCredentials)entry.getValue();
            String mavenServerId = (String)entry.getKey();
            Node currentDefinition = (Node)removedMavenServers.get(mavenServerId);
            if (credential instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials usernamePasswordCredentials = (StandardUsernamePasswordCredentials)credential;
                LOGGER.log(Level.FINE, "Maven Server ID {0}: use {1} / {2}", new Object[]{mavenServerId, usernamePasswordCredentials.getId(), usernamePasswordCredentials.getDescription()});
                Element server = doc.createElement("server");
                Element id = doc.createElement("id");
                id.setTextContent(mavenServerId);
                Element password = doc.createElement("password");
                password.setTextContent(Secret.toString((Secret)usernamePasswordCredentials.getPassword()));
                Element username = doc.createElement("username");
                username.setTextContent(usernamePasswordCredentials.getUsername());
                server.appendChild(id);
                server.appendChild(username);
                server.appendChild(password);
                CredentialsHelper.copyServerAttributes(currentDefinition, server);
                serversNode.appendChild(server);
                continue;
            }
            if (credential instanceof SSHUserPrivateKey) {
                String privateKeyContent;
                SSHUserPrivateKey sshUserPrivateKey = (SSHUserPrivateKey)credential;
                List privateKeys = sshUserPrivateKey.getPrivateKeys();
                if (privateKeys.isEmpty()) {
                    LOGGER.log(Level.WARNING, "Maven Server ID {0}: not private key defined in {1}, skip", new Object[]{mavenServerId, sshUserPrivateKey.getId()});
                    continue;
                }
                if (privateKeys.size() == 1) {
                    LOGGER.log(Level.FINE, "Maven Server ID {0}: use {1}", new Object[]{mavenServerId, sshUserPrivateKey.getId()});
                    privateKeyContent = (String)privateKeys.get(0);
                } else {
                    LOGGER.log(Level.WARNING, "Maven Server ID {0}: more than one ({1}) private key defined in {1}, use first private key", new Object[]{mavenServerId, privateKeys.size(), sshUserPrivateKey.getId()});
                    privateKeyContent = (String)privateKeys.get(0);
                }
                Element server = doc.createElement("server");
                Element id = doc.createElement("id");
                id.setTextContent(mavenServerId);
                Element username = doc.createElement("username");
                username.setTextContent(sshUserPrivateKey.getUsername());
                workDir.mkdirs();
                FilePath privateKeyFile = workDir.createTextTempFile("private-key-", ".pem", privateKeyContent, true);
                privateKeyFile.chmod(384);
                tempFiles.add(privateKeyFile.getRemote());
                LOGGER.log(Level.FINE, "Create {0}", new Object[]{privateKeyFile.getRemote()});
                Element privateKey = doc.createElement("privateKey");
                privateKey.setTextContent(privateKeyFile.getRemote());
                Element passphrase = doc.createElement("passphrase");
                passphrase.setTextContent(Secret.toString((Secret)sshUserPrivateKey.getPassphrase()));
                server.appendChild(id);
                server.appendChild(username);
                server.appendChild(privateKey);
                server.appendChild(passphrase);
                CredentialsHelper.copyServerAttributes(currentDefinition, server);
                serversNode.appendChild(server);
                continue;
            }
            LOGGER.log(Level.WARNING, "Maven Server ID {0}: credentials type of {1} not supported: {2}", new Object[]{mavenServerId, credential == null ? null : credential.getId(), credential == null ? null : credential.getClass()});
        }
        StringWriter writer = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        content = writer.toString();
        return content;
    }

    private static void copyServerAttributes(Node from, Node to) {
        if (from == null || to == null) {
            return;
        }
        NodeList nodes = from.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = StringUtils.trimToNull((String)node.getNodeName());
            if (!ATTRIBUTES_TO_KEEPT.contains(name)) continue;
            to.appendChild(node);
        }
    }

    private static Map<String, Node> removeMavenServerDefinitions(Node serversNode, Set<String> credentialKeys, boolean replaceAll) {
        LinkedHashMap<String, Node> serverId2Node = new LinkedHashMap<String, Node>(credentialKeys.size());
        NodeList serverNodes = serversNode.getChildNodes();
        for (int i = 0; i < serverNodes.getLength(); ++i) {
            Node server = serverNodes.item(i);
            String serverId = CredentialsHelper.getServerId(server);
            if (!replaceAll && !credentialKeys.contains(serverId)) continue;
            Node removed = serversNode.removeChild(server);
            if (credentialKeys.contains(serverId)) {
                serverId2Node.put(serverId, removed);
            }
            --i;
        }
        return serverId2Node;
    }

    private static String getServerId(Node server) {
        NodeList nodes = server.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = StringUtils.lowerCase((String)node.getNodeName());
            String content = StringUtils.trimToNull((String)node.getTextContent());
            if (!"id".equals(name)) continue;
            return content;
        }
        return null;
    }
}

