/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFileStore;

@Extension
public class GlobalConfigFiles
extends Descriptor<GlobalConfigFiles>
implements ConfigFileStore,
ExtensionPoint,
Describable<GlobalConfigFiles> {
    private Collection<Config> configs = new ArrayList<Config>();

    public final Descriptor<GlobalConfigFiles> getDescriptor() {
        return this;
    }

    public static GlobalConfigFiles get() {
        GlobalConfigFiles instance = (GlobalConfigFiles)Jenkins.getActiveInstance().getDescriptorList(GlobalConfigFiles.class).get(GlobalConfigFiles.class);
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    public GlobalConfigFiles() {
        super(GlobalConfigFiles.self());
        ExtensionList<ConfigProvider> allProviders = ConfigProvider.all();
        for (ConfigProvider p : allProviders) {
            for (Config c : ((AbstractConfigProviderImpl)p).getConfigs().values()) {
                Object converted = ((AbstractConfigProviderImpl)p).convert(c);
                this.configs.add((Config)converted);
            }
        }
        if (this.configs.size() > 0) {
            this.save();
            for (ConfigProvider p : allProviders) {
                p.clearOldDataStorage();
            }
        } else {
            this.load();
        }
    }

    @Override
    public Map<ConfigProvider, Collection<Config>> getGroupedConfigs() {
        HashMap<ConfigProvider, Collection<Config>> grouped = new HashMap<ConfigProvider, Collection<Config>>();
        for (Config c : this.configs) {
            ArrayList<Config> configs = (ArrayList<Config>)grouped.get((Object)c.getProvider());
            if (configs == null) {
                configs = new ArrayList<Config>();
                grouped.put(c.getProvider(), configs);
            }
            configs.add(c);
        }
        return grouped;
    }

    @Override
    public Collection<Config> getConfigs() {
        return this.configs;
    }

    @Override
    public Collection<Config> getConfigs(Class<? extends Descriptor> descriptor) {
        ArrayList<Config> cs = new ArrayList<Config>();
        for (Config c : this.configs) {
            if (!((Object)((Object)c.getDescriptor())).getClass().equals(descriptor)) continue;
            cs.add(c);
        }
        return cs;
    }

    @Override
    public Config getById(String id) {
        for (Config c : this.configs) {
            if (!id.equals(c.id)) continue;
            return c;
        }
        return null;
    }

    @Override
    public void save(Config config) {
        this.configs.add(config);
        this.save();
    }

    @Override
    public void remove(String id) {
        Config c = this.getById(id);
        this.configs.remove(c);
        this.save();
    }
}

