/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.configprovider;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;

public abstract class ConfigProvider
extends Descriptor<Config>
implements ExtensionPoint {
    public static ExtensionList<ConfigProvider> all() {
        return Jenkins.getActiveInstance().getExtensionList(ConfigProvider.class);
    }

    @CheckForNull
    public static ConfigProvider getByIdOrNull(@Nullable String providerId) {
        if (providerId == null || providerId.isEmpty()) {
            return null;
        }
        for (ConfigProvider provider : ConfigProvider.all()) {
            if (!providerId.equals(provider.getProviderId())) continue;
            return provider;
        }
        return null;
    }

    public abstract ContentType getContentType();

    public abstract String getProviderId();

    @Deprecated
    public abstract Config newConfig();

    @NonNull
    public Config newConfig(@NonNull String id) {
        throw new AbstractMethodError(((Object)((Object)this)).getClass() + " MUST implement 'newConfig(String)'");
    }

    public abstract void clearOldDataStorage();

    public boolean supportsFolder() {
        return true;
    }
}

