/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.InputStream;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class MavenToolchainsConfig
extends Config {
    private static final long serialVersionUID = 1L;

    public MavenToolchainsConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    @DataBoundConstructor
    public MavenToolchainsConfig(String id, String name, String comment, String content, String providerId) {
        super(id, name, comment, content, providerId);
    }

    public MavenToolchainsConfig(Config config) {
        super(config);
    }

    @Override
    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.getActiveInstance().getDescriptorByType(MavenToolchainsConfigProvider.class);
    }

    @Extension(ordinal=180.0)
    public static class MavenToolchainsConfigProvider
    extends AbstractConfigProviderImpl {
        public MavenToolchainsConfigProvider() {
            this.load();
        }

        @Override
        public ContentType getContentType() {
            return ContentType.DefinedType.XML;
        }

        public String getDisplayName() {
            return Messages.mvn_toolchains_provider_name();
        }

        @Override
        protected String getXmlFileName() {
            return "maven-toolchains-files.xml";
        }

        @Override
        public Config newConfig() {
            String id = this.getProviderId() + System.currentTimeMillis();
            return new MavenToolchainsConfig(id, "MyToolchains", "", this.loadTemplateContent());
        }

        @Override
        @NonNull
        public Config newConfig(@NonNull String id) {
            return new MavenToolchainsConfig(id, "MyToolchains", "", this.loadTemplateContent(), this.getProviderId());
        }

        @Override
        public <T extends Config> T convert(Config config) {
            return (T)new MavenToolchainsConfig(config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String loadTemplateContent() {
            String string;
            InputStream in = null;
            try {
                in = ((Object)((Object)this)).getClass().getResourceAsStream("toolchains-tpl.xml");
                string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            }
            catch (Exception e) {
                String string2;
                try {
                    string2 = "<toolchains></toolchains>";
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                return string2;
            }
            IOUtils.closeQuietly((InputStream)in);
            return string;
        }
    }
}

