/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.groovy;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class GroovyScript
extends Config {
    private static final long serialVersionUID = 1L;

    public GroovyScript(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    @DataBoundConstructor
    public GroovyScript(String id, String name, String comment, String content, String providerId) {
        super(id, name, comment, content, providerId);
    }

    public GroovyScript(Config config) {
        super(config);
    }

    @Override
    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.getActiveInstance().getDescriptorByType(GroovyConfigProvider.class);
    }

    @Extension(ordinal=100.0)
    public static class GroovyConfigProvider
    extends AbstractConfigProviderImpl {
        protected transient String ID_PREFIX;

        public GroovyConfigProvider() {
            this.load();
        }

        @Override
        public ContentType getContentType() {
            return ContentType.DefinedType.GROOVY;
        }

        public String getDisplayName() {
            return Messages.groovy_provider_name();
        }

        @Override
        public <T extends Config> T convert(Config config) {
            return (T)new GroovyScript(config);
        }

        @Override
        public Config newConfig() {
            String id = this.getProviderId() + System.currentTimeMillis();
            return new GroovyScript(id, "GroovyConfig", "", "println('hello world')");
        }

        @Override
        @NonNull
        public Config newConfig(@NonNull String id) {
            return new GroovyScript(id, "GroovyConfig", "", "println('hello world')", this.getProviderId());
        }

        @Override
        protected String getXmlFileName() {
            return "groovy-config-files.xml";
        }

        static {
            Jenkins.XSTREAM.alias("org.jenkinsci.plugins.configfiles.groovy.GroovyConfigProvider", GroovyConfigProvider.class);
        }
    }
}

