/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import hudson.Extension;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFileStore;

public class FolderConfigFileProperty
extends AbstractFolderProperty<AbstractFolder<?>>
implements ConfigFileStore {
    private Collection<Config> configs = new ArrayList<Config>();
    private transient AbstractFolder<?> owner;

    FolderConfigFileProperty(AbstractFolder<?> owner) {
        this.setOwner(owner);
    }

    @Override
    public Collection<Config> getConfigs() {
        return this.configs;
    }

    @Override
    public Collection<Config> getConfigs(Class<? extends Descriptor> descriptor) {
        ArrayList<Config> cs = new ArrayList<Config>();
        for (Config c : this.configs) {
            if (!((Object)((Object)c.getDescriptor())).getClass().equals(descriptor)) continue;
            cs.add(c);
        }
        return cs;
    }

    @Override
    public Config getById(String id) {
        for (Config c : this.configs) {
            if (!id.equals(c.id)) continue;
            return c;
        }
        return null;
    }

    @Override
    public void save(Config config) {
        this.configs.add(config);
        try {
            this.getOwner().save();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to save config to store", e);
        }
    }

    @Override
    public void remove(String id) {
        Config c = this.getById(id);
        this.configs.remove(c);
        try {
            this.getOwner().save();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to remove config from store", e);
        }
    }

    @Override
    public Map<ConfigProvider, Collection<Config>> getGroupedConfigs() {
        HashMap<ConfigProvider, Collection<Config>> grouped = new HashMap<ConfigProvider, Collection<Config>>();
        for (Config c : this.configs) {
            ArrayList<Config> configs = (ArrayList<Config>)grouped.get((Object)c.getProvider());
            if (configs == null) {
                configs = new ArrayList<Config>();
                grouped.put(c.getProvider(), configs);
            }
            configs.add(c);
        }
        return grouped;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        public String getDisplayName() {
            return "";
        }
    }
}

