/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.compatibilityaction;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.compatibilityaction.CompatibilityDataException;
import org.jenkinsci.plugins.compatibilityaction.CompatibilityDataProvider;
import org.jenkinsci.plugins.compatibilityaction.MongoDBHolderService;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.mongojack.DBCursor;
import org.mongojack.JacksonDBCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoProviderImpl
extends CompatibilityDataProvider {
    private String database;
    private String collection;
    private String username;
    private String host = "localhost";
    private int port = 27017;
    private Secret password;
    private MongoDBHolderService service;

    @DataBoundConstructor
    public MongoProviderImpl(String host, int port, String database, String collection, String username, Secret password) {
        this.port = port;
        this.host = host;
        this.database = database;
        this.collection = collection;
        this.username = username;
        this.password = password;
        this.service = new MongoDBHolderService(username, password, port, host, database);
    }

    public MongoProviderImpl(MongoDBHolderService service) {
        this.service = service;
    }

    public MongoProviderImpl() {
    }

    public Descriptor<CompatibilityDataProvider> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(MongoProviderImpl.class);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Secret getPassword() {
        return this.password;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public MongoDBHolderService getService() {
        return this.service;
    }

    public void setService(MongoDBHolderService service) {
        this.service = service;
    }

    @Override
    public <T> T create(T t) throws CompatibilityDataException {
        MongoClient client = null;
        try {
            client = this.getService().createClient();
            JacksonDBCollection coll = JacksonDBCollection.wrap((DBCollection)client.getDB(this.database).getCollection(this.collection), t.getClass());
            Object object = coll.insert(t).getSavedObject();
            return (T)object;
        }
        catch (Exception ex) {
            throw new CompatibilityDataException(String.format("Failed to insert object %s", t), ex);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Override
    public <T> T create(T t, TaskListener listener) throws CompatibilityDataException {
        Object client = null;
        try {
            Object myobj;
            DB db = this.getService().createClient().getDB(this.database);
            if (!db.getCollectionNames().contains(this.collection)) {
                db.createCollection(this.collection, null);
            }
            JacksonDBCollection coll = JacksonDBCollection.wrap((DBCollection)db.getCollection(this.collection), t.getClass());
            listener.getLogger().println(String.format("%s Collection initialized.", "[COMPATIBILITY]"));
            Object object = myobj = coll.insert(t).getSavedObject();
            return (T)object;
        }
        catch (Exception ex) {
            throw new CompatibilityDataException(String.format("Failed to insert object %s", t), ex);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Override
    public <T> T read(Object key, Class<T> clazz) throws CompatibilityDataException {
        MongoClient client = null;
        try {
            client = this.getService().createClient();
            JacksonDBCollection coll = JacksonDBCollection.wrap((DBCollection)client.getDB(this.database).getCollection(this.collection), clazz);
            Object object = coll.findOneById(key);
            return (T)object;
        }
        catch (Exception ex) {
            throw new CompatibilityDataException(String.format("Failed to fetch object with key %s", key), ex);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    public <T> List<T> readMany(BasicDBObject query, Class<T> clazz) throws CompatibilityDataException {
        ArrayList<Object> list = new ArrayList<Object>();
        DBCursor cursor = null;
        MongoClient client = null;
        try {
            client = this.getService().createClient();
            JacksonDBCollection coll = JacksonDBCollection.wrap((DBCollection)client.getDB(this.database).getCollection(this.collection), clazz);
            cursor = coll.find((DBObject)query);
            while (cursor.hasNext()) {
                list.add(cursor.next());
            }
        }
        catch (Exception ex) {
            throw new CompatibilityDataException(String.format("Failed to fetch object with query %s", query), ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return list;
    }

    public int count(DBObject query) throws CompatibilityDataException {
        MongoClient client = null;
        try {
            client = this.getService().createClient();
            int n = client.getDB(this.database).getCollection(this.collection).find(query).sort((DBObject)new BasicDBObject("registrationDate", (Object)1)).size();
            return n;
        }
        catch (Exception ex) {
            throw new CompatibilityDataException(String.format("(Unknown Host) Failed to fetch object with query %s", query), ex);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    public List<DBObject> listAndSort(DBObject query, BasicDBObject sorter) throws CompatibilityDataException {
        ArrayList<DBObject> objects = new ArrayList<DBObject>();
        com.mongodb.DBCursor cursor = null;
        MongoClient client = null;
        try {
            client = this.getService().createClient();
            cursor = client.getDB(this.database).getCollection(this.collection).find(query).sort((DBObject)sorter);
            while (cursor.hasNext()) {
                objects.add(cursor.next());
            }
        }
        catch (Exception ex) {
            throw new CompatibilityDataException(String.format("(Unknown Host) Failed to fetch object with query %s", query), ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return objects;
    }

    public String toString() {
        return "Mongo@" + this.getHost() + ":" + this.getPort() + "@" + this.getCollection();
    }

    @Extension
    public static final class MongoProviderDescriptor
    extends CompatibilityDataProvider.CompatabilityDataProviderDescriptor {
        public MongoProviderDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return "MongoDB";
        }

        public FormValidation doTestConnection(@QueryParameter(value="host") String host, @QueryParameter(value="port") int port, @QueryParameter(value="password") Secret password, @QueryParameter(value="username") String username, @QueryParameter(value="database") String database, @QueryParameter(value="collection") String collection) {
            String res = "";
            try {
                res = new MongoDBHolderService(username, password, port, host, database).testConnection(collection);
            }
            catch (CompatibilityDataException ex) {
                return FormValidation.error((String)ex.getMessage());
            }
            catch (Exception unknown) {
                return FormValidation.error((String)unknown.getMessage());
            }
            String msg = !StringUtils.isBlank((String)res) ? res : "";
            return FormValidation.okWithMarkup((String)("Connection established. Listing a random element." + msg));
        }
    }
}

