// CHECKSTYLE:OFF

package org.jenkinsci.plugins.command_launcher;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code CommandLauncher.unexpectedError}: {@code Unexpected error
     * in launching an agent. This is probably a bug in Jenkins}.
     * 
     * @return
     *     {@code Unexpected error in launching an agent. This is probably a bug
     *     in Jenkins}
     */
    public static String CommandLauncher_unexpectedError() {
        return holder.format("CommandLauncher.unexpectedError");
    }

    /**
     * Key {@code CommandLauncher.unexpectedError}: {@code Unexpected error
     * in launching an agent. This is probably a bug in Jenkins}.
     * 
     * @return
     *     {@code Unexpected error in launching an agent. This is probably a bug
     *     in Jenkins}
     */
    public static Localizable _CommandLauncher_unexpectedError() {
        return new Localizable(holder, "CommandLauncher.unexpectedError");
    }

    /**
     * Key {@code CommandLauncher.NoLaunchCommand}: {@code No launch command
     * specified}.
     * 
     * @return
     *     {@code No launch command specified}
     */
    public static String CommandLauncher_NoLaunchCommand() {
        return holder.format("CommandLauncher.NoLaunchCommand");
    }

    /**
     * Key {@code CommandLauncher.NoLaunchCommand}: {@code No launch command
     * specified}.
     * 
     * @return
     *     {@code No launch command specified}
     */
    public static Localizable _CommandLauncher_NoLaunchCommand() {
        return new Localizable(holder, "CommandLauncher.NoLaunchCommand");
    }

    /**
     * Key {@code CommandLauncher.displayName}: {@code Launch agent via
     * execution of command on the controller}.
     * 
     * @return
     *     {@code Launch agent via execution of command on the controller}
     */
    public static String CommandLauncher_displayName() {
        return holder.format("CommandLauncher.displayName");
    }

    /**
     * Key {@code CommandLauncher.displayName}: {@code Launch agent via
     * execution of command on the controller}.
     * 
     * @return
     *     {@code Launch agent via execution of command on the controller}
     */
    public static Localizable _CommandLauncher_displayName() {
        return new Localizable(holder, "CommandLauncher.displayName");
    }

    /**
     * Key {@code Slave.Launching}: {@code {0} Launching agent}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} Launching agent}
     */
    public static String Slave_Launching(Object arg0) {
        return holder.format("Slave.Launching", arg0);
    }

    /**
     * Key {@code Slave.Launching}: {@code {0} Launching agent}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} Launching agent}
     */
    public static Localizable _Slave_Launching(Object arg0) {
        return new Localizable(holder, "Slave.Launching", arg0);
    }

    /**
     * Key {@code CommandLauncher.abortedLaunch}: {@code Launching agent
     * process aborted.}.
     * 
     * @return
     *     {@code Launching agent process aborted.}
     */
    public static String CommandLauncher_abortedLaunch() {
        return holder.format("CommandLauncher.abortedLaunch");
    }

    /**
     * Key {@code CommandLauncher.abortedLaunch}: {@code Launching agent
     * process aborted.}.
     * 
     * @return
     *     {@code Launching agent process aborted.}
     */
    public static Localizable _CommandLauncher_abortedLaunch() {
        return new Localizable(holder, "CommandLauncher.abortedLaunch");
    }

    /**
     * Key {@code Slave.UnableToLaunch}: {@code Unable to launch the agent
     * for {0}{1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to launch the agent for {0}{1}}
     */
    public static String Slave_UnableToLaunch(Object arg0, Object arg1) {
        return holder.format("Slave.UnableToLaunch", arg0, arg1);
    }

    /**
     * Key {@code Slave.UnableToLaunch}: {@code Unable to launch the agent
     * for {0}{1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to launch the agent for {0}{1}}
     */
    public static Localizable _Slave_UnableToLaunch(Object arg0, Object arg1) {
        return new Localizable(holder, "Slave.UnableToLaunch", arg0, arg1);
    }

}
