/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.collabnet.steps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public abstract class SynchNonBlockingStepExecution<T>
extends StepExecution {
    private volatile transient Future<?> task;
    private transient String threadName;
    private static ExecutorService executorService;

    protected SynchNonBlockingStepExecution(@Nonnull StepContext context) {
        super(context);
    }

    protected abstract T run() throws Exception;

    public final boolean start() throws Exception {
        final Authentication auth = Jenkins.getAuthentication();
        this.task = SynchNonBlockingStepExecution.getExecutorService().submit(new Runnable(){

            @Override
            @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="not serializing anything here")
            public void run() {
                try {
                    SynchNonBlockingStepExecution.this.getContext().onSuccess(ACL.impersonate((Authentication)auth, (Callable)new NotReallyRoleSensitiveCallable<T, Exception>(){

                        public T call() throws Exception {
                            SynchNonBlockingStepExecution.this.threadName = Thread.currentThread().getName();
                            return SynchNonBlockingStepExecution.this.run();
                        }
                    }));
                }
                catch (Exception e) {
                    SynchNonBlockingStepExecution.this.getContext().onFailure((Throwable)e);
                }
            }
        });
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    public void onResume() {
        this.getContext().onFailure((Throwable)new Exception("Resume after a restart not supported for non-blocking synchronous steps"));
    }

    @Nonnull
    public String getStatus() {
        if (this.threadName != null) {
            return "running in thread: " + this.threadName;
        }
        return "not yet scheduled";
    }

    static synchronized ExecutorService getExecutorService() {
        if (executorService == null) {
            executorService = Executors.newCachedThreadPool((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), "jenkins.plugins.collabnet.steps.SynchronousNonBlockingStepExecution"));
        }
        return executorService;
    }
}

