/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class Helper {
    static Logger logger = Logger.getLogger(Helper.class.getName());
    private static String LOG_MESSAGE_PREFIX = "TeamForge/EventQ Build Notifier - ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken(URL ctfUrl, String ctfUserName, String ctfPassword) throws IOException {
        String end_point = ctfUrl.toString() + "/oauth/auth/token";
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String token = null;
        try {
            httpClient = CNFormFieldValidator.getHttpClient();
            HttpPost post = new HttpPost(end_point);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("client_id", "api-client"));
            params.add(new BasicNameValuePair("grant_type", "password"));
            params.add(new BasicNameValuePair("username", ctfUserName));
            params.add(new BasicNameValuePair("password", ctfPassword));
            params.add(new BasicNameValuePair("scope", "urn:ctf:services:ctf urn:ctf:services:svn urn:ctf:services:gerrit"));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            response = httpClient.execute((HttpUriRequest)post);
            token = JSONObject.fromObject((Object)EntityUtils.toString((HttpEntity)response.getEntity())).get("access_token").toString();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "TeamForge Associations - " + e.getLocalizedMessage(), e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWebhookToken(String webhookUrl, String webhookUsername, String webhookPassword, TaskListener listener) throws IOException {
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        String token = null;
        try {
            client = CNFormFieldValidator.getHttpClient();
            HttpPost httpPost = new HttpPost(webhookUrl);
            StringEntity entity = new StringEntity(Helper.getLoginData(webhookUsername, webhookPassword).toString());
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            response = client.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                token = JSONObject.fromObject((Object)EntityUtils.toString((HttpEntity)response.getEntity())).getJSONObject("Response").get("SessionToken").toString();
            }
        }
        catch (IOException e) {
            String errMsg = e.getMessage();
            Helper.logMsg(errMsg, listener, logger, e);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "TeamForge Associations - " + e.getLocalizedMessage(), e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return token;
    }

    public static void logMsg(String errMsg, TaskListener listener, Logger logger, Exception e) {
        if (errMsg.startsWith("; nested exception is: \n\tjavax.net.ssl.SSLHandshakeException: ")) {
            listener.getLogger().println("SSL configuration error. Please check your SSL certificate and retry.");
            logger.log(Level.INFO, "TeamForge Associations - " + e.getLocalizedMessage(), e);
        } else if (errMsg.endsWith("java.net.SocketTimeoutException: connect timed out")) {
            listener.getLogger().println("Connection timed out. Please check the configuration.");
            logger.log(Level.INFO, "TeamForge Associations - " + e.getLocalizedMessage(), e);
        } else if (errMsg.endsWith("java.net.ConnectException: Connection timed out")) {
            listener.getLogger().println("Connection timed out. Please check the configuration.");
            logger.log(Level.INFO, "TeamForge Associations - " + e.getLocalizedMessage(), e);
        } else if (errMsg.endsWith(": Connection refused")) {
            listener.getLogger().println("Connection refused. Please check the configuration.");
            logger.log(Level.INFO, "TeamForge Associatqions - " + e.getLocalizedMessage(), e);
        } else {
            listener.getLogger().println(e.getLocalizedMessage());
            logger.log(Level.INFO, "TeamForge Associations - " + e.getLocalizedMessage(), e);
        }
    }

    private static JSONObject getLoginData(String webhookUsername, String webhookPassword) {
        return new JSONObject().element("Username", (Object)webhookUsername).element("Password", (Object)webhookPassword);
    }

    public static void markUnstable(Run build, PrintStream consoleLogger, String message, String className) {
        if (consoleLogger != null) {
            Helper.log(message, consoleLogger);
            Logger logger = Logger.getLogger(className);
            logger.warning(message);
            build.setResult(Result.UNSTABLE);
        }
    }

    public static void log(String msg, PrintStream printStream) {
        printStream.print(LOG_MESSAGE_PREFIX);
        printStream.println(msg);
    }

    public static StandardUsernamePasswordCredentials getCredentials(Item owner, String credentialsId, String webhookUrl) {
        StandardUsernamePasswordCredentials result = null;
        if (!StringUtils.isBlank((String)credentialsId)) {
            for (StandardUsernamePasswordCredentials c : Helper.lookupCredentials(owner, webhookUrl)) {
                if (!c.getId().equals(credentialsId)) continue;
                result = c;
                break;
            }
        }
        return result;
    }

    public static List<StandardUsernamePasswordCredentials> lookupCredentials(Item owner, String webhookUrl) {
        URIRequirementBuilder rBuilder = StringUtils.isBlank((String)webhookUrl) ? URIRequirementBuilder.create() : URIRequirementBuilder.fromUri((String)webhookUrl);
        return CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)owner, null, (List)rBuilder.build());
    }
}

