/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;

public class CommonUtil {
    private CommonUtil() {
    }

    public static boolean getBoolean(String key, JSONObject formData) {
        boolean value = false;
        String valueStr = (String)formData.get(key);
        if (valueStr != null) {
            value = valueStr.equals("true");
        }
        return value;
    }

    public static String getInterpreted(Map<String, String> envVars, String str) {
        Pattern envPat = Pattern.compile("\\$\\{(\\w*)\\}");
        Matcher matcher = envPat.matcher(str);
        StringBuffer intStr = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            if (!envVars.containsKey(key)) {
                String message = "Environmental Variable not found: " + key;
                throw new IllegalArgumentException(message);
            }
            String value = envVars.get(key);
            matcher.appendReplacement(intStr, value);
        }
        matcher.appendTail(intStr);
        return intStr.toString();
    }

    public static void logRE(Logger logger, String methodName, RemoteException re) {
        logger.info(methodName + " failed due to " + re.getClass().getName() + ": " + re.getMessage());
    }

    @Deprecated
    public static Collection<String> sanitizeForJS(Collection<String> collection) {
        ArrayList<String> sanitized = new ArrayList<String>();
        for (String c : collection) {
            c = c.replace("\\", "\\\\");
            c = c.replace("'", "\\'");
            c = c.replace("\"", "\\\"");
            c = c.replace("<", "\\<");
            c = c.replace(">", "\\>");
            sanitized.add(c);
        }
        return sanitized;
    }

    public static String stripSlashes(String str) {
        str = str.replaceAll("^/+", "");
        return str.replaceAll("/+$", "");
    }

    public static boolean unset(String value) {
        return value == null || value.equals("");
    }

    public static List<String> splitCommaStr(String commaStr) {
        ArrayList<String> results = new ArrayList<String>(Arrays.asList(commaStr.trim().split("\\s*,\\s*")));
        Iterator it = results.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (!(next = next.trim()).equals("")) continue;
            it.remove();
        }
        return results;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

