/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.orchestrate;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MessageProperties;
import hudson.plugins.collabnet.orchestrate.OrchestrateClient;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;

public class AmqpOrchestrateClient
implements OrchestrateClient {
    private static final String DEFAULT_QUEUE_NAME = "orchestrate.builds";
    private static final String DEFAULT_EXCHANGE_NAME = "";
    private ConnectionFactory factory = new ConnectionFactory();
    private String exchangeName = "";
    private String routingKey = "orchestrate.builds";
    private AMQP.BasicProperties properties = MessageProperties.PERSISTENT_TEXT_PLAIN;

    public AmqpOrchestrateClient() {
    }

    public AmqpOrchestrateClient(ConnectionFactory connectionFactory) {
        this();
        this.factory = connectionFactory;
    }

    @Override
    public void postBuild(String serverUrl, String serverUsername, String serverPassword, String buildInformation) throws IOException {
        Connection conn = null;
        Channel channel = null;
        try {
            URI uri = new URI(serverUrl);
            if (serverUrl.endsWith("/")) {
                serverUrl = serverUrl.substring(0, serverUrl.lastIndexOf("/"));
            }
            this.factory.setUri(serverUrl);
            if (!StringUtils.isBlank((CharSequence)serverUsername)) {
                this.factory.setUsername(serverUsername);
                this.factory.setPassword(serverPassword);
            }
            conn = this.factory.newConnection();
            channel = conn.createChannel();
            channel.queueDeclare(this.routingKey, true, false, false, null);
            byte[] messageBodyBytes = buildInformation.getBytes("UTF-8");
            channel.basicPublish(this.exchangeName, this.routingKey, this.properties, messageBodyBytes);
        }
        catch (Exception e) {
            String errorMsg = "Unable to send build info to the message queue";
            throw new IOException(errorMsg, e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public AMQP.BasicProperties getProperties() {
        return this.properties;
    }
}

