/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.documentuploader;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.plugins.promoted_builds.Promotion;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FilePattern
extends AbstractDescribableImpl<FilePattern> {
    public final String value;

    @DataBoundConstructor
    public FilePattern(String value) {
        this.value = value;
    }

    public String interpret(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        EnvVars envVars;
        if (Hudson.getInstance().getPlugin("promoted-builds") != null && build.getClass().equals(Promotion.class)) {
            Promotion promotion = (Promotion)Promotion.class.cast(build);
            envVars = promotion.getTarget().getEnvironment(listener);
        } else {
            envVars = build.getEnvironment(listener);
        }
        return CommonUtil.getInterpreted((Map<String, String>)envVars, this.value);
    }

    public boolean equals(Object that) {
        return this.value.equals(((FilePattern)((Object)that)).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == FilePattern.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            FilePattern src = (FilePattern)((Object)source);
            writer.setValue(src.value);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return new FilePattern(reader.getValue());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<FilePattern> {
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckValue(@QueryParameter String value) throws FormValidation {
            return CNFormFieldValidator.unrequiredInterpretedCheck(value, "file patterns");
        }
    }
}

