/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.documentuploader;

import com.collabnet.ce.webservices.CTFDocument;
import com.collabnet.ce.webservices.CTFDocumentFolder;
import com.collabnet.ce.webservices.CTFFile;
import com.collabnet.ce.webservices.CTFProject;
import com.collabnet.ce.webservices.CollabNetApp;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.AbstractTeamForgeNotifier;
import hudson.plugins.collabnet.ConnectionFactory;
import hudson.plugins.collabnet.documentuploader.CnduResultAction;
import hudson.plugins.collabnet.documentuploader.FilePattern;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepMonitor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.MimetypesFileTypeMap;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CNDocumentUploader
extends AbstractTeamForgeNotifier {
    private static Logger logger = Logger.getLogger("CNDocumentUploader");
    private static final String IMAGE_URL = "/plugin/collabnet/images/48x48/";
    private transient BuildListener listener = null;
    private transient CollabNetApp cna = null;
    private String uploadPath;
    private String description;
    private FilePattern[] file_patterns;
    private boolean includeBuildLog;

    @DataBoundConstructor
    public CNDocumentUploader(ConnectionFactory connectionFactory, String project, String uploadPath, String description, FilePattern[] filePatterns, boolean includeBuildLog) {
        super(connectionFactory, project);
        this.uploadPath = uploadPath;
        this.description = description;
        this.file_patterns = filePatterns;
        this.includeBuildLog = includeBuildLog;
    }

    private void setupLogging(BuildListener listener) {
        this.listener = listener;
    }

    private void logConsole(String message) {
        if (this.listener != null) {
            message = "CollabNet Document Uploader: " + message;
            this.listener.getLogger().println(message);
        }
    }

    private void logConsole(String message, Exception exception) {
        if (this.listener != null) {
            message = "CollabNet Document Uploader: " + message;
            this.listener.getLogger().println(message);
            exception.printStackTrace(this.listener.error("error"));
        }
    }

    private void log(String methodName, RemoteException re) {
        CommonUtil.logRE(logger, methodName, re);
    }

    public String getUploadPath() {
        return this.uploadPath;
    }

    public String getDescription() {
        return this.description;
    }

    public FilePattern[] getFilePatterns() {
        if (this.file_patterns != null) {
            return this.file_patterns;
        }
        return new FilePattern[0];
    }

    public boolean getIncludeBuildLog() {
        return this.includeBuildLog;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        CTFDocumentFolder folder;
        this.setupLogging(listener);
        this.cna = this.connect();
        if (this.cna == null) {
            this.logConsole("Critical Error: login to " + this.getCollabNetUrl() + " failed.  Setting build status to UNSTABLE (or worse).");
            build.setResult(Result.UNSTABLE);
            build.addAction(this.createAction(0, null));
            return false;
        }
        CTFProject p = this.cna.getProjectByTitle(this.getProject());
        if (p == null) {
            this.logConsole("Critical Error: Unable to find project '" + this.getProject() + "'.  " + "Setting build status to UNSTABLE (or worse).");
            build.setResult(Result.UNSTABLE);
            build.addAction(this.createAction(0, null));
            this.logoff();
            return false;
        }
        String path = this.getInterpreted(build, this.getUploadPath());
        try {
            folder = p.getOrCreateDocumentFolder(path);
        }
        catch (RemoteException re) {
            this.log("findOrCreatePath", re);
            this.logConsole("Critical Error: Unable to create a path for '" + path + "'.  Setting build status to " + "UNSTABLE (or worse).");
            build.setResult(Result.UNSTABLE);
            build.addAction(this.createAction(0, null));
            this.logoff();
            return false;
        }
        int numUploaded = this.uploadFiles(folder, build, listener);
        build.addAction(this.createAction(numUploaded, folder));
        try {
            this.cna.logoff();
        }
        catch (RemoteException re) {
            this.log("logoff", re);
        }
        return true;
    }

    private Action createAction(int numUploaded, CTFDocumentFolder folder) {
        String displaymsg = "Download from CollabNet Documents";
        return new CnduResultAction(displaymsg, "/plugin/collabnet/images/48x48/CollabNetDocuments.png", "console", folder.getURL(), numUploaded);
    }

    public int uploadFiles(CTFDocumentFolder folder, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        int numUploaded = 0;
        String path = this.getInterpreted(build, this.getUploadPath());
        this.logConsole("Uploading files to project '" + this.getProject() + "', folder '" + path + "' on host '" + this.getCollabNetUrl() + "' as user '" + this.getUsername() + "'.");
        for (FilePattern uninterp_fp : this.getFilePatterns()) {
            FilePath[] filePaths;
            String file_pattern;
            try {
                file_pattern = uninterp_fp.interpret(build, (TaskListener)listener);
            }
            catch (IllegalArgumentException e) {
                this.logConsole("File pattern " + (Object)((Object)uninterp_fp) + " contained a bad env var.  Skipping.");
                continue;
            }
            if (file_pattern.equals("")) continue;
            for (FilePath uploadFilePath : filePaths = this.getFilePaths(build, file_pattern)) {
                CTFFile file = this.uploadFile(uploadFilePath);
                if (file == null) {
                    this.logConsole("Failed to upload " + uploadFilePath.getName() + ".");
                    continue;
                }
                try {
                    CTFDocument doc = this.updateOrCreateDoc(folder, file, uploadFilePath.getName(), CNDocumentUploader.getMimeType(uploadFilePath), build);
                    this.logConsole("Uploaded " + uploadFilePath.getName() + " -> " + doc.getURL());
                    ++numUploaded;
                }
                catch (RemoteException re) {
                    this.logConsole("Upload file failed: " + re.getMessage());
                    this.log("updateOrCreateDoc", re);
                }
            }
        }
        if (this.getIncludeBuildLog()) {
            CTFFile file = this.uploadBuildLog(build);
            if (file == null) {
                this.logConsole("Failed to upload " + build.getLogFile().getName() + ".");
            } else {
                try {
                    CTFDocument docId = this.updateOrCreateDoc(folder, file, build.getLogFile().getName(), CNDocumentUploader.getMimeType(build.getLogFile()), build);
                    this.logConsole("Uploaded " + build.getLogFile().getName() + " -> " + docId.getURL());
                    ++numUploaded;
                }
                catch (RemoteException re) {
                    this.logConsole("Upload log failed: " + re.getMessage(), re);
                    this.log("updateOrCreateDoc", re);
                }
            }
        }
        return numUploaded;
    }

    private FilePath[] getFilePaths(AbstractBuild<?, ?> build, String pattern) {
        FilePath workspace = FreeStyleProject.class.isInstance(build.getProject()) ? build.getWorkspace() : build.getProject().getRootProject().getWorkspace();
        String logEntry = "Searching ant pattern '" + pattern + "'";
        FilePath[] uploadFilePaths = new FilePath[]{};
        try {
            uploadFilePaths = workspace.list(pattern);
            logEntry = logEntry + " in " + workspace.absolutize().getRemote();
        }
        catch (IOException ioe) {
            this.logConsole("Could not list workspace due to IOException: " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            this.logConsole("Could not list workspace due to InterruptedException: " + ie.getMessage());
        }
        logEntry = logEntry + " : found " + uploadFilePaths.length + " entry(ies)";
        this.logConsole(logEntry);
        return uploadFilePaths;
    }

    private CTFDocument updateOrCreateDoc(CTFDocumentFolder folder, CTFFile file, String fileName, String mimeType, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        CTFDocument doc = folder.getDocuments().byTitle(fileName);
        if (doc != null) {
            doc.update(file);
            return doc;
        }
        return folder.createDocument(fileName, this.getInterpreted(build, this.getDescription()), "", "final", false, fileName, mimeType, file, null, null);
    }

    public static String getMimeType(FilePath filePath) {
        String mimeType = "text/plain";
        try {
            mimeType = (String)filePath.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

                public String invoke(File f, VirtualChannel channel) throws IOException {
                    if (f.getName().endsWith("log")) {
                        return "text/plain";
                    }
                    return new MimetypesFileTypeMap().getContentType(f);
                }

                public void checkRoles(RoleChecker arg0) throws SecurityException {
                }
            });
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return mimeType;
    }

    public static String getMimeType(File f) {
        if (f.getName().endsWith("log")) {
            return "text/plain";
        }
        return new MimetypesFileTypeMap().getContentType(f);
    }

    private CTFFile uploadBuildLog(AbstractBuild<?, ?> build) {
        if (this.cna == null) {
            this.logConsole("Cannot call updateSucceedingBuild, not logged in!");
            return null;
        }
        try {
            return this.cna.upload(build.getLogFile());
        }
        catch (RemoteException re) {
            this.log("uploadBuildLog", re);
            return null;
        }
    }

    private CTFFile uploadFile(FilePath filePath) {
        if (this.cna == null) {
            this.logConsole("Cannot call uploadFile, not logged in!");
            return null;
        }
        try {
            String id = (String)filePath.act((FilePath.FileCallable)new RemoteFileUploader(this.getCollabNetUrl(), this.getUsername(), this.cna.getSessionId()));
            return new CTFFile(this.cna, id);
        }
        catch (RemoteException re) {
            this.logConsole("upload file failed", re);
        }
        catch (IOException ioe) {
            this.logConsole("Could not upload file due to IOException: " + ioe.getMessage(), ioe);
        }
        catch (InterruptedException ie) {
            this.logConsole("Could not upload file due to InterruptedException: " + ie.getMessage());
        }
        return null;
    }

    public void logoff() {
        CNHudsonUtil.logoff(this.cna);
        this.cna = null;
    }

    private String getInterpreted(AbstractBuild<?, ?> build, String str) throws IOException, InterruptedException {
        try {
            return CommonUtil.getInterpreted((Map<String, String>)build.getEnvironment(TaskListener.NULL), str);
        }
        catch (IllegalArgumentException iae) {
            this.logConsole(iae.getMessage());
            throw iae;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractTeamForgeNotifier.DescriptorImpl {
        public String getDisplayName() {
            return "CollabNet Document Uploader";
        }

        public FormValidation doCheckUploadPath(CollabNetApp app, @QueryParameter String project, @QueryParameter String value) throws IOException {
            return CNFormFieldValidator.documentPathCheck(app, project, value);
        }

        public FormValidation doCheckDescription(@QueryParameter String value) {
            return CNFormFieldValidator.requiredCheck(value, "description");
        }
    }

    private static class RemoteFileUploader
    implements FilePath.FileCallable<String> {
        private String mUrl;
        private String mUsername;
        private String mSessionId;

        public RemoteFileUploader(String url, String username, String sessionId) {
            this.mUrl = url;
            this.mUsername = username;
            this.mSessionId = sessionId;
        }

        public String invoke(File f, VirtualChannel channel) throws IOException {
            CollabNetApp cnApp = CNHudsonUtil.recreateCollabNetApp(this.mUrl, this.mUsername, this.mSessionId);
            return cnApp.upload(f).getId();
        }

        public void checkRoles(RoleChecker arg0) throws SecurityException {
        }
    }
}

