/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.collabnet.steps;

import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.orchestrate.BuildNotifier;
import hudson.plugins.collabnet.orchestrate.PushNotification;
import hudson.plugins.collabnet.util.Helper;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.plugins.collabnet.steps.SynchNonBlockingStepExecution;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class PublishWebhookStep
extends Step {
    private final String webhookUrl;
    private String credentialsId;
    @DataBoundSetter
    public boolean markUnstable;
    @DataBoundSetter
    public String status;
    @DataBoundSetter
    public boolean excludeCommitInfo;

    @DataBoundConstructor
    public PublishWebhookStep(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public StepExecution start(StepContext context) throws Exception {
        PublishWebhookStepExecution execution = new PublishWebhookStepExecution(this, context);
        return execution;
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public static class PublishWebhookStepExecution
    extends SynchNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private static final Logger logger = Logger.getLogger(PublishWebhookStepExecution.class.getName());
        private transient PublishWebhookStep step;
        private transient TaskListener listener;
        private transient Run<?, ?> run;
        private transient PushNotification pushNotification;
        public static String LOG_MESSAGE_PREFIX = "TeamForge Build Notifier - ";
        public static String LOG_MESSAGE_INVALID_URL = "The Webhook URL to the TeamForge server is missing.";

        public PublishWebhookStepExecution(PublishWebhookStep step, @Nonnull StepContext ctx) throws IOException, InterruptedException {
            super(ctx);
            this.step = step;
            this.listener = (TaskListener)this.getContext().get(TaskListener.class);
            this.run = (Run)this.getContext().get(Run.class);
        }

        @Override
        protected Void run() throws Exception {
            PrintStream consoleLogger = this.listener.getLogger();
            this.pushNotification = new PushNotification();
            String webhookUrl = this.step.getWebhookUrl();
            if (StringUtils.isBlank((String)webhookUrl)) {
                this.markUnstable(consoleLogger, "Build information NOT sent: " + LOG_MESSAGE_INVALID_URL);
                return null;
            }
            try {
                String username;
                StandardUsernamePasswordCredentials c = this.getCredentials();
                String string = username = c == null ? null : c.getUsername();
                String password = c == null ? null : (c.getPassword() == null ? null : c.getPassword().getPlainText());
                BuildNotifier.OptionalWebhook webhook = new BuildNotifier.OptionalWebhook(webhookUrl, username, password);
                this.pushNotification.handle(this.run, webhook, this.listener, this.step.status, this.step.excludeCommitInfo);
            }
            catch (IllegalStateException ise) {
                this.markUnstable(consoleLogger, "Build information NOT sent: this step needs a Jenkins URL (go to Manage Jenkins > Configure System; click Save)");
                ise.printStackTrace(consoleLogger);
            }
            catch (Exception e) {
                this.markUnstable(consoleLogger, e.getMessage());
                this.log("Build information NOT sent, details below", consoleLogger);
                e.printStackTrace(consoleLogger);
            }
            return null;
        }

        private void markUnstable(PrintStream consoleLogger, String message) {
            this.log(message, consoleLogger);
            logger.warning(message);
            if ((this.step == null || this.step.markUnstable) && this.run != null) {
                this.run.setResult(Result.UNSTABLE);
            }
        }

        private void log(String msg, PrintStream printStream) {
            printStream.print(LOG_MESSAGE_PREFIX);
            printStream.println(msg);
        }

        public StandardUsernamePasswordCredentials getCredentials() {
            return Helper.getCredentials((Item)this.run.getParent(), this.step.getCredentialsId(), this.step.getWebhookUrl());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "publishTeamForge";
        }

        public String getDisplayName() {
            return "Notify TeamForge";
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }

        public ListBoxModel doFillStatusItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("-- Auto --", "");
            items.add("SUCCESS", "SUCCESS");
            items.add("UNSTABLE", "UNSTABLE");
            items.add("ABORTED", "ABORTED");
            items.add("FAILURE", "FAILURE");
            return items;
        }

        public FormValidation doCheckWebhookUrl(@QueryParameter String webhookUrl) {
            return FormValidation.validateRequired((String)webhookUrl);
        }

        public FormValidation doCheckStatus(@QueryParameter String status) {
            if (StringUtils.isBlank((String)status) || status.toLowerCase().startsWith("success") || status.toLowerCase().equals("unstable") || status.toLowerCase().equals("aborted") || status.toLowerCase().startsWith("fail")) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid TeamForge status value");
        }

        public FormValidation doCheckCredentialsId(@QueryParameter String credentialsId, @AncestorInPath Item owner) {
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel().withEmptySelection();
            }
            String useServerUrl = null;
            return new StandardUsernameListBoxModel().withEmptySelection().withAll(Helper.lookupCredentials(owner, useServerUrl));
        }
    }
}

