/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import com.collabnet.ce.webservices.CTFPackage;
import com.collabnet.ce.webservices.CTFProject;
import com.collabnet.ce.webservices.CTFRelease;
import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.ObjectWithTitle;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.util.ComboBoxModel;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.logging.Logger;

public abstract class ComboBoxUpdater {
    protected static Logger log = Logger.getLogger("ComboBoxUpdater");
    private static final ComboBoxModel EMPTY_MODEL = new ComboBoxModel();

    private ComboBoxUpdater() {
    }

    public static ComboBoxModel getProjectList(CollabNetApp cna) {
        if (cna != null) {
            try {
                return ComboBoxUpdater.toModel(cna.getProjects());
            }
            catch (RemoteException re) {
                CommonUtil.logRE(log, "getProjectList", re);
            }
        }
        return EMPTY_MODEL;
    }

    public static ComboBoxModel getPackages(CollabNetApp cna, String project) throws RemoteException {
        if (cna == null) {
            return EMPTY_MODEL;
        }
        CTFProject p = cna.getProjectByTitle(project);
        if (p == null) {
            return EMPTY_MODEL;
        }
        return ComboBoxUpdater.toModel(p.getPackages());
    }

    public static ComboBoxModel getReleases(CollabNetApp cna, String project, String rpackage) throws RemoteException {
        if (cna == null) {
            return EMPTY_MODEL;
        }
        CTFProject p = cna.getProjectByTitle(project);
        if (p == null) {
            return EMPTY_MODEL;
        }
        if (CommonUtil.unset(rpackage)) {
            return ComboBoxUpdater.getReleaseList(p);
        }
        CTFPackage pkg = p.getPackages().byTitle(rpackage);
        return ComboBoxUpdater.getReleaseList(pkg);
    }

    public static ComboBoxModel getReleaseList(CTFPackage pkg) throws RemoteException {
        if (pkg == null) {
            return EMPTY_MODEL;
        }
        return ComboBoxUpdater.toModel(pkg.getReleases());
    }

    public static ComboBoxModel getReleaseList(CTFProject p) throws RemoteException {
        if (p == null) {
            return EMPTY_MODEL;
        }
        ComboBoxModel cbm = new ComboBoxModel();
        for (CTFPackage pkg : p.getPackages()) {
            for (CTFRelease r : pkg.getReleases()) {
                cbm.add((Object)r.getTitle());
            }
        }
        return cbm;
    }

    public static ComboBoxModel getRepos(CollabNetApp cna, String project) throws RemoteException {
        if (cna == null) {
            return EMPTY_MODEL;
        }
        CTFProject p = cna.getProjectByTitle(project);
        if (p == null) {
            return EMPTY_MODEL;
        }
        return ComboBoxUpdater.toModel(p.getScmRepositories());
    }

    public static ComboBoxModel toModel(Collection<? extends ObjectWithTitle> list) {
        ComboBoxModel r = new ComboBoxModel();
        for (ObjectWithTitle objectWithTitle : list) {
            r.add((Object)objectWithTitle.getTitle());
        }
        return r;
    }

    public static ComboBoxModel getTrackerList(CTFProject p) throws RemoteException {
        if (p != null) {
            return ComboBoxUpdater.toModel(p.getTrackers());
        }
        return EMPTY_MODEL;
    }

    public static ComboBoxModel getUsers(CollabNetApp cna, String project) throws RemoteException {
        if (cna != null) {
            CTFProject p = cna.getProjectByTitle(project);
            if (p == null) {
                return EMPTY_MODEL;
            }
            return ComboBoxUpdater.toModel(p.getMembers());
        }
        return EMPTY_MODEL;
    }

    public static ComboBoxModel getUserList(CTFProject p) {
        if (p != null) {
            try {
                return ComboBoxUpdater.toModel(p.getMembers());
            }
            catch (RemoteException re) {
                CommonUtil.logRE(log, "getUserList", re);
            }
        }
        return EMPTY_MODEL;
    }
}

