/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.util;

import com.collabnet.ce.webservices.CTFPackage;
import com.collabnet.ce.webservices.CTFProject;
import com.collabnet.ce.webservices.CTFRelease;
import com.collabnet.ce.webservices.CTFScmRepository;
import com.collabnet.ce.webservices.CTFTracker;
import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.cubit.api.CubitConnector;
import hudson.plugins.collabnet.CtfSoapHttpSender;
import hudson.plugins.collabnet.auth.CNAuthentication;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.axis.utils.StringUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.kohsuke.stapler.StaplerRequest;

public abstract class CNFormFieldValidator {
    public static void checkInterpretedString(String str) throws FormValidation {
        Pattern envPat = Pattern.compile("\\$\\{(\\w*)\\}");
        Matcher matcher = envPat.matcher(str);
        HashSet<String> envVars = new HashSet<String>(9);
        envVars.add("BUILD_NUMBER");
        envVars.add("BUILD_ID");
        envVars.add("JOB_NAME");
        envVars.add("BUILD_TAG");
        envVars.add("EXECUTOR_NUMBER");
        envVars.add("JAVA_HOME");
        envVars.add("WORKSPACE");
        envVars.add("HUDSON_URL");
        envVars.add("SVN_REVISION");
        envVars.add("CVS_BRANCH");
        String message = null;
        while (matcher.find()) {
            String key = matcher.group(1);
            if (envVars.contains(key)) continue;
            if (message == null) {
                message = "Environmental Variables not found: " + key;
                continue;
            }
            message = message + ", " + key;
        }
        if (message != null) {
            throw FormValidation.error(message);
        }
    }

    /*
     * Exception decompiling
     */
    public static FormValidation checkUrl(String url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static CloseableHttpClient getHttpClient() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        if (CollabNetApp.areSslErrorsIgnored()) {
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)CtfSoapHttpSender.tryCreateAcceptAllSslSocketFactory()).build();
        }
        return HttpClients.createDefault();
    }

    public static FormValidation requiredCheck(String value, String name) {
        value = StringUtils.strip((String)value);
        if (CommonUtil.unset(name)) {
            name = "above value";
        }
        if (CommonUtil.unset(value)) {
            return FormValidation.error((String)("The " + name + " is required."));
        }
        return FormValidation.ok();
    }

    public static FormValidation interpretedCheck(String str, String name, boolean isRequired) throws FormValidation {
        if (CommonUtil.unset(str)) {
            if (!isRequired) {
                return FormValidation.ok();
            }
            if (CommonUtil.unset(name)) {
                name = "above value";
            }
            return FormValidation.error((String)("The " + name + " is required."));
        }
        CNFormFieldValidator.checkInterpretedString(str);
        return FormValidation.ok();
    }

    public static FormValidation unrequiredInterpretedCheck(String str, String name) throws FormValidation {
        return CNFormFieldValidator.interpretedCheck(str, name, false);
    }

    public static FormValidation requiredInterpretedCheck(String str, String name) throws FormValidation {
        return CNFormFieldValidator.interpretedCheck(str, name, true);
    }

    public static FormValidation hostUrlCheck(String hostUrl) {
        if (CommonUtil.unset(hostUrl)) {
            return FormValidation.error((String)"The Host URL is required.");
        }
        return CNFormFieldValidator.checkUrl(hostUrl);
    }

    public static FormValidation soapUrlCheck(String collabNetUrl) {
        if (CommonUtil.unset(collabNetUrl)) {
            return FormValidation.error((String)"The CollabNet TeamForge URL is required.");
        }
        return CNFormFieldValidator.checkSoapUrl(collabNetUrl);
    }

    private static FormValidation checkSoapUrl(String collabNetUrl) {
        String soapURL = collabNetUrl + CollabNetApp.SOAP_SERVICE + "CollabNet?wsdl";
        return CNFormFieldValidator.checkUrl(soapURL);
    }

    public static FormValidation loginCheck(CollabNetApp app, String password) {
        if (CommonUtil.unset(password)) {
            return FormValidation.error((String)"The password is required.");
        }
        if (app == null) {
            return FormValidation.warning((String)"Login fails with this CollabNet URL/username/password combination.");
        }
        CNHudsonUtil.logoff(app);
        return FormValidation.ok();
    }

    public static FormValidation projectCheck(CollabNetApp app, String project) throws RemoteException {
        if (CommonUtil.unset(project)) {
            return FormValidation.error((String)"The project is required.");
        }
        if (app != null) {
            try {
                if (app.getProjectByTitle(project) == null) {
                    FormValidation formValidation = FormValidation.warning((String)String.format("Project '%s' cannot be found, or user %s does not have permission to access it.", project, app.getUsername()));
                    return formValidation;
                }
            }
            finally {
                CNHudsonUtil.logoff(app);
            }
        }
        return FormValidation.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormValidation documentPathCheck(CollabNetApp app, String project, String path) throws IOException {
        try {
            String missing;
            path = path.replaceAll("/+", "/");
            path = CommonUtil.stripSlashes(path);
            if (CommonUtil.unset(path)) {
                FormValidation formValidation = FormValidation.error((String)"The path is required.");
                return formValidation;
            }
            CNFormFieldValidator.checkInterpretedString(path);
            if (app == null) {
                FormValidation formValidation = FormValidation.ok();
                return formValidation;
            }
            CTFProject p = app.getProjectByTitle(project);
            if (p != null && (missing = p.verifyPath(path)) != null) {
                FormValidation formValidation = FormValidation.warning((String)String.format("Folder '%s' could not be found in path '%s'.  It (and any subfolders) will be created dynamically.", missing, path));
                return formValidation;
            }
        }
        finally {
            CNHudsonUtil.logoff(app);
        }
        return FormValidation.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormValidation packageCheck(CollabNetApp cna, String project, String rpackage) throws RemoteException {
        try {
            CTFPackage pkg;
            if (CommonUtil.unset(rpackage)) {
                FormValidation formValidation = FormValidation.error((String)"The package is required.");
                return formValidation;
            }
            if (cna == null) {
                FormValidation formValidation = FormValidation.ok();
                return formValidation;
            }
            CTFProject p = cna.getProjectByTitle(project);
            if (p != null && (pkg = p.getPackages().byTitle(rpackage)) == null) {
                FormValidation formValidation = FormValidation.warning((String)"Package could not be found.");
                return formValidation;
            }
            FormValidation formValidation = FormValidation.ok();
            return formValidation;
        }
        finally {
            CNHudsonUtil.logoff(cna);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormValidation releaseCheck(CollabNetApp cna, String project, String rpackage, String release, boolean required) throws RemoteException {
        try {
            if (CommonUtil.unset(release)) {
                if (required) {
                    FormValidation formValidation = FormValidation.error((String)"The release is required.");
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.ok();
                return formValidation;
            }
            if (cna == null) {
                FormValidation formValidation = FormValidation.ok();
                return formValidation;
            }
            CTFProject p = cna.getProjectByTitle(project);
            if (p == null) {
                FormValidation formValidation = FormValidation.ok();
                return formValidation;
            }
            String releaseMsg = "Release could not be found. A new release will be created.";
            CTFPackage pkg = p.getPackages().byTitle(rpackage);
            if (pkg != null) {
                CTFRelease r = pkg.getReleaseByTitle(release);
                if (r == null) {
                    FormValidation formValidation = FormValidation.warning((String)releaseMsg);
                    return formValidation;
                }
            } else {
                for (CTFPackage x : p.getPackages()) {
                    if (x.getReleaseByTitle(release) == null) continue;
                    FormValidation formValidation = FormValidation.ok();
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.warning((String)releaseMsg);
                return formValidation;
            }
            FormValidation formValidation = FormValidation.ok();
            return formValidation;
        }
        finally {
            CNHudsonUtil.logoff(cna);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormValidation repoCheck(StaplerRequest request) throws RemoteException {
        String project = request.getParameter("project");
        String repoName = request.getParameter("repo");
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(request);
        try {
            CTFScmRepository r;
            if (cna == null) {
                FormValidation formValidation = FormValidation.ok();
                return formValidation;
            }
            CTFProject p = cna.getProjectByTitle(project);
            if (CommonUtil.unset(repoName)) {
                FormValidation formValidation = FormValidation.error((String)"The repository name is required.");
                return formValidation;
            }
            if (p != null && (r = p.getScmRepositories().byTitle(repoName)) == null) {
                FormValidation formValidation = FormValidation.warning((String)"Repository could not be found.");
                return formValidation;
            }
            FormValidation formValidation = FormValidation.ok();
            return formValidation;
        }
        finally {
            CNHudsonUtil.logoff(cna);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormValidation trackerCheck(CollabNetApp cna, String project, String tracker) throws RemoteException {
        if (CommonUtil.unset(tracker)) {
            return FormValidation.error((String)"The tracker is required.");
        }
        try {
            CTFTracker t;
            if (cna == null) {
                FormValidation formValidation = FormValidation.ok();
                return formValidation;
            }
            CTFProject p = cna.getProjectByTitle(project);
            if (p != null && (t = p.getTrackers().byTitle(tracker)) == null) {
                FormValidation formValidation = FormValidation.warning((String)"Tracker could not be found.");
                return formValidation;
            }
            FormValidation formValidation = FormValidation.ok();
            return formValidation;
        }
        finally {
            CNHudsonUtil.logoff(cna);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormValidation assignCheck(CollabNetApp cna, String project, String assign) throws RemoteException {
        if (CommonUtil.unset(assign = StringUtils.strip((String)assign))) {
            return FormValidation.ok();
        }
        try {
            if (cna == null) {
                FormValidation formValidation = FormValidation.ok();
                return formValidation;
            }
            CTFProject p = cna.getProjectByTitle(project);
            if (p == null) {
                FormValidation formValidation = FormValidation.ok();
                return formValidation;
            }
            if (!p.hasMember(assign)) {
                FormValidation formValidation = FormValidation.warning((String)"This user is not a member of the project.");
                return formValidation;
            }
            FormValidation formValidation = FormValidation.ok();
            return formValidation;
        }
        finally {
            CNHudsonUtil.logoff(cna);
        }
    }

    public static FormValidation userListCheck(String userStr) throws RemoteException {
        if (userStr == null || userStr.equals("")) {
            return FormValidation.ok();
        }
        CNAuthentication auth = CNAuthentication.get();
        if (auth == null || !auth.isSuperUser()) {
            return FormValidation.warning((String)"Cannot check if users exist unless logged in as a TeamForge site admin.  Be careful!");
        }
        Collection<String> invalidUsers = CNFormFieldValidator.getInvalidUsers(auth.getCredentials(), userStr);
        if (!invalidUsers.isEmpty()) {
            return FormValidation.error((String)("The following users do not exist: " + invalidUsers));
        }
        return FormValidation.ok();
    }

    private static Collection<String> getInvalidUsers(CollabNetApp cna, String userStr) throws RemoteException {
        ArrayList<String> invalidUsers = new ArrayList<String>();
        if (cna != null) {
            for (String user : CommonUtil.splitCommaStr(userStr)) {
                if (cna.isUsernameValid(user)) continue;
                invalidUsers.add(user);
            }
        }
        return invalidUsers;
    }

    public static FormValidation groupListCheck(String groupStr, String userStr) throws RemoteException {
        Collection<String> invalidGroups = CNFormFieldValidator.getInvalidGroups(groupStr);
        if (!invalidGroups.isEmpty()) {
            return FormValidation.error((String)("The following groups do not exist: " + invalidGroups));
        }
        if (userStr != null && CNFormFieldValidator.locksOutCurrentUser(userStr, groupStr)) {
            return FormValidation.error((String)"The authorization settings would lock the current user out of this page.  You may want to add your username to the user list.");
        }
        return FormValidation.ok();
    }

    private static Collection<String> getInvalidGroups(String groupStr) throws RemoteException {
        CNAuthentication auth = CNAuthentication.get();
        if (auth == null) {
            return Collections.emptyList();
        }
        if (!auth.isSuperUser()) {
            return Collections.emptyList();
        }
        HashSet<String> invalidGroups = new HashSet<String>(CommonUtil.splitCommaStr(groupStr));
        invalidGroups.removeAll(auth.getCredentials().getGroups().getTitles());
        return invalidGroups;
    }

    private static boolean locksOutCurrentUser(String userStr, String groupStr) {
        CNAuthentication auth = CNAuthentication.get();
        if (auth == null) {
            return false;
        }
        if (auth.isSuperUser()) {
            return false;
        }
        String currentUser = auth.getPrincipal();
        for (String user : CommonUtil.splitCommaStr(userStr)) {
            if (!user.equals(currentUser)) continue;
            return false;
        }
        return !auth.isMemberOfAny(CommonUtil.splitCommaStr(groupStr));
    }

    public static FormValidation regexCheck(String regex) {
        if (!CommonUtil.unset(regex)) {
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException ex) {
                return FormValidation.error((String)"The regular expression is not syntactically correct.");
            }
        }
        return FormValidation.ok();
    }

    public static FormValidation cubitKeyCheck(String hostUrl, String user, String key) {
        Secret decryptkey = Secret.decrypt((String)key);
        if (decryptkey != null) {
            key = Secret.toString((Secret)decryptkey);
        }
        if (CommonUtil.unset(key)) {
            return FormValidation.error((String)"The user API key is required.");
        }
        if (!key.matches("\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}")) {
            if (key.startsWith(" ")) {
                return FormValidation.error((String)"The key's format is invalid.  There is a leading space.");
            }
            if (key.endsWith(" ")) {
                return FormValidation.error((String)"The key's format is invalid.  There is a trailing space.");
            }
            return FormValidation.error((String)"The key's format is invalid.");
        }
        if (!CommonUtil.unset(hostUrl) && !CommonUtil.unset(user)) {
            boolean success;
            try {
                success = CNFormFieldValidator.signedStatus(hostUrl, user, key);
            }
            catch (IllegalArgumentException iae) {
                success = false;
            }
            if (!success) {
                return FormValidation.warning((String)"This host URL, username, and user API key combination cannot successfully sign in.");
            }
        }
        return FormValidation.ok();
    }

    private static boolean signedStatus(String host, String user, String key) {
        String status;
        key = key.toLowerCase();
        CubitConnector conn = new CubitConnector(host, user, key);
        try {
            status = conn.callCubitApi("status_signed", new HashMap(), true);
        }
        catch (IOException e) {
            return false;
        }
        Pattern pat = Pattern.compile(".*OK.*", 32);
        return pat.matcher(status).matches();
    }

    public static FormValidation numberCheck(String number, boolean allowPositive, boolean allowZero, boolean allowNegative) {
        int integer;
        try {
            integer = Integer.parseInt(number);
        }
        catch (Exception e) {
            integer = 0;
        }
        if (integer < 0 && !allowNegative) {
            return FormValidation.error((String)("Integer cannot be negative: " + integer));
        }
        if (integer == 0 && !allowZero) {
            return FormValidation.error((String)("Integer cannot be zero: " + integer));
        }
        if (integer > 0 && !allowPositive) {
            return FormValidation.error((String)("Integer cannot be positive: " + integer));
        }
        return FormValidation.ok();
    }
}

