/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.orchestrate;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.collabnet.orchestrate.BuildNotifier;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class BuildNotifierDescriptor
extends BuildStepDescriptor<Publisher> {
    private String serverUrl;
    private String serverUsername;
    private Secret serverPassword;

    public BuildNotifierDescriptor() {
        super(BuildNotifier.class);
        this.load();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public String getDisplayName() {
        return "Notify TeamForge/EventQ when a build completes";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.serverUrl = formData.getString("serverUrl");
        this.serverUsername = formData.getString("serverUsername");
        this.serverPassword = Secret.fromString((String)formData.getString("serverPassword"));
        this.save();
        return super.configure(req, formData);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerUsername() {
        return this.serverUsername;
    }

    public String getServerPassword() {
        String plainTextPassword = Secret.toString((Secret)this.serverPassword);
        return StringUtils.isBlank((String)plainTextPassword) ? null : plainTextPassword;
    }

    public FormValidation doCheckServerUrl(@QueryParameter String serverUrl) {
        return FormValidation.validateRequired((String)serverUrl);
    }

    public FormValidation doCheckServerUsername(@QueryParameter String serverUsername) {
        return FormValidation.validateRequired((String)serverUsername);
    }

    public FormValidation doCheckServerPassword(@QueryParameter String serverPassword) {
        return FormValidation.validateRequired((String)serverPassword);
    }

    public FormValidation doCheckSourceKey(@QueryParameter String sourceKey) {
        return FormValidation.validateRequired((String)sourceKey);
    }

    public boolean canInheritAuth() {
        return BuildNotifierDescriptor.getTeamForgeShareDescriptor().useGlobal();
    }

    public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        return TeamForgeShare.getTeamForgeShareDescriptor();
    }
}

