/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CollabNetApp;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CollabNetAuthManager;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import hudson.util.VersionNumber;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.AuthenticationManager;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CollabNetSecurityRealm
extends SecurityRealm {
    private String collabNetUrl;
    private boolean mEnableSSOAuthFromCTF;
    private boolean mEnableSSOAuthToCTF;
    private boolean mEnableSSORedirect = true;
    private static final Logger LOGGER = Logger.getLogger(CollabNetSecurityRealm.class.getName());

    @DataBoundConstructor
    public CollabNetSecurityRealm(String collabNetUrl, boolean enableSSOAuthFromCTF, boolean enableSSOAuthToCTF) {
        this.collabNetUrl = CNHudsonUtil.sanitizeCollabNetUrl(collabNetUrl);
        this.mEnableSSOAuthFromCTF = enableSSOAuthFromCTF;
        this.mEnableSSOAuthToCTF = enableSSOAuthToCTF;
        CollabNetApp cn = new CollabNetApp(this.collabNetUrl);
        try {
            VersionNumber apiVersion = new VersionNumber(cn.getApiVersion());
            if (apiVersion.compareTo(new VersionNumber("5.3.0.0")) >= 0) {
                this.mEnableSSORedirect = false;
            }
        }
        catch (RemoteException re) {
            LOGGER.log(Level.WARNING, "Failed to retrieve the CTF version from " + this.collabNetUrl, re);
        }
    }

    public String getCollabNetUrl() {
        return this.collabNetUrl;
    }

    public boolean getEnableSSOAuthFromCTF() {
        return this.mEnableSSOAuthFromCTF;
    }

    public boolean getEnableSSOAuthToCTF() {
        return this.mEnableSSOAuthToCTF;
    }

    public boolean getEnableSSORedirect() {
        return this.mEnableSSORedirect;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents((AuthenticationManager)new CollabNetAuthManager(this.getCollabNetUrl()));
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "CollabNet Security Realm";
        }

        public FormValidation doCheckCollabNetUrl(@QueryParameter String value) {
            if (!Jenkins.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            String collabNetUrl = value;
            if (collabNetUrl == null || collabNetUrl.equals("")) {
                return FormValidation.error((String)"The CollabNet URL is required.");
            }
            return this.checkSoapUrl(collabNetUrl);
        }

        private FormValidation checkSoapUrl(String collabNetUrl) {
            String soapURL = collabNetUrl + CollabNetApp.SOAP_SERVICE + "CollabNet?wsdl";
            return CNFormFieldValidator.checkUrl(soapURL);
        }
    }
}

