/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CTFProject;
import com.collabnet.ce.webservices.CTFUser;
import com.collabnet.ce.webservices.CollabNetApp;
import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CNAuthorizationCache;
import hudson.security.Permission;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;

public class CNAuthentication
implements Authentication {
    public static final String SUPER_USER = "SuperUser";
    private final String principal;
    private final CTFUser myself;
    private final CollabNetApp cna;
    private GrantedAuthority[] authorities;
    private Collection<String> groups;
    private boolean authenticated = false;
    private boolean cnauthed = false;
    private CNAuthorizationCache mAuthCache = null;
    private static Logger log = Logger.getLogger("CNAuthentication");

    public CNAuthentication(Object principal, Object credentials) throws RemoteException {
        this.principal = (String)principal;
        this.cna = (CollabNetApp)credentials;
        this.myself = this.cna.getMyself();
        this.setupAuthorities();
        this.setupGroups();
        this.setAuthenticated(true);
        this.mAuthCache = new CNAuthorizationCache();
    }

    private void setupAuthorities() {
        boolean isSuper = false;
        try {
            isSuper = this.myself.isSuperUser();
        }
        catch (RemoteException re) {
            log.info("setupAuthoritites: failed with RemoteException: " + re.getMessage());
        }
        if (isSuper) {
            this.authorities = new GrantedAuthority[2];
            this.authorities[0] = new GrantedAuthorityImpl(SUPER_USER);
            this.authorities[1] = new GrantedAuthorityImpl("authenticated");
        } else {
            this.authorities = new GrantedAuthority[1];
            this.authorities[0] = new GrantedAuthorityImpl("authenticated");
        }
    }

    private void setupGroups() {
        this.groups = Collections.emptyList();
        try {
            this.groups = this.myself.getGroupNames();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public GrantedAuthority[] getAuthorities() {
        GrantedAuthority[] authCopy = new GrantedAuthority[this.authorities.length];
        System.arraycopy(this.authorities, 0, authCopy, 0, this.authorities.length);
        return authCopy;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getName() {
        return this.getPrincipal();
    }

    public Object getDetails() {
        return null;
    }

    public CollabNetApp getCredentials() {
        return this.cna;
    }

    public boolean isMember(String group) {
        return this.groups.contains(group);
    }

    public String toString() {
        return "CNAuthentication [for: " + this.getPrincipal() + ", authenticated=" + this.isAuthenticated() + "]";
    }

    public boolean isCNAuthed() {
        return this.cnauthed;
    }

    public void setCNAuthed(boolean cnauthed) {
        this.cnauthed = cnauthed;
    }

    public boolean isSuperUser() {
        for (GrantedAuthority authority : this.getAuthorities()) {
            if (!authority.getAuthority().equals(SUPER_USER)) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberOfAny(Collection<String> groups) {
        for (String group : groups) {
            if (!this.isMember(group)) continue;
            return true;
        }
        return false;
    }

    public boolean isProjectAdmin(CTFProject p) {
        try {
            return p.getAdmins().contains(this.cna.getMyself());
        }
        catch (RemoteException re) {
            log.info("isProjectAdmin: failed with RemoteException: " + re.getMessage());
            return false;
        }
    }

    public String getSessionId() {
        return this.getCredentials().getSessionId();
    }

    public Set<Permission> getUserProjectPermSet(String username, String projectId) {
        return this.mAuthCache.getUserProjectPermSet(username, projectId);
    }

    public static CNAuthentication get() {
        return CNAuthentication.cast(Hudson.getAuthentication());
    }

    public static CNAuthentication cast(Authentication a) {
        if (a instanceof CNAuthentication) {
            return (CNAuthentication)a;
        }
        return null;
    }
}

