/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.actionhub;

import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import hudson.plugins.collabnet.actionhub.ActionHubPlugin;
import hudson.plugins.collabnet.actionhub.Constants;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class MQConnectionHandler
implements ShutdownListener {
    private static final Logger log = Logger.getLogger(MQConnectionHandler.class.getName());

    public void shutdownCompleted(ShutdownSignalException cause) {
        boolean reConnectSuccess = true;
        int count = 0;
        log.info("Lost connection to RabbitMQ");
        do {
            int timeInterval = Constants.RABBIT_CONNECTION_RETRY_INTERVALS[count];
            try {
                TimeUnit.MINUTES.sleep(timeInterval);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            log.info("Been " + timeInterval + " minute(s). Going to retry.");
            reConnectSuccess = true;
            try {
                ActionHubPlugin.connectAndListen();
            }
            catch (IOException ioe) {
                reConnectSuccess = false;
            }
            catch (TimeoutException te) {
                reConnectSuccess = false;
            }
        } while (!reConnectSuccess && ++count < Constants.RABBIT_CONNECTION_RETRY_INTERVALS.length);
        if (!reConnectSuccess) {
            log.info("Unable to reconnect to Rabbit. Giving up.");
        }
    }
}

