/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.actionhub;

import hudson.model.Cause;
import java.util.HashMap;

public class BuildCause
extends Cause {
    private final String queueName;
    private final String ruleName;
    private final String userName;
    private final String projectName;
    private final String projectId;
    private final Integer matchCount;
    private final String matchCountString;

    public BuildCause(String queueName, HashMap<String, Object> ruleInformation) {
        this.queueName = queueName;
        this.ruleName = (String)ruleInformation.get("ruleName");
        this.userName = (String)ruleInformation.get("userName");
        this.projectName = ruleInformation.get("projectName") == null ? "N/A" : (String)ruleInformation.get("projectName");
        this.projectId = ruleInformation.get("projectId") == null ? "N/A" : (String)ruleInformation.get("projectId");
        if (ruleInformation.get("matchCount") == null) {
            this.matchCount = 0;
            this.matchCountString = "N/A";
        } else {
            this.matchCount = (Integer)ruleInformation.get("matchCount");
            this.matchCountString = this.matchCount.toString();
        }
    }

    public String getShortDescription() {
        return "Triggered when rule '" + this.ruleName + "' from the " + this.projectName + " project (" + this.projectId + ") was matched " + this.matchCountString + " time(s). Triggerred by ActionHub user '" + this.userName + "' via remote build message from queue " + this.queueName + ".";
    }
}

