/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.net.CommonsHTTPClientProperties;
import org.apache.axis.components.net.CommonsHTTPClientPropertiesFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.NetworkUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class CtfSoapHttpSender
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    protected CommonsHTTPClientProperties clientProperties;
    protected CloseableHttpClient httpClient;

    public void init() {
        this.clientProperties = CommonsHTTPClientPropertiesFactory.create();
        this.httpClient = this.createHttpClient(this.createConnectionManager());
    }

    public void cleanup() {
        try {
            this.httpClient.close();
            this.httpClient = null;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close HTTP client: " + e.getMessage(), e);
        }
    }

    protected Registry<ConnectionSocketFactory> createSocketFactoryRegistry() {
        SSLConnectionSocketFactory sslFactory = CtfSoapHttpSender.tryCreateAcceptAllSslSocketFactory();
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslFactory).build();
    }

    protected PoolingHttpClientConnectionManager createConnectionManager() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(this.createSocketFactoryRegistry());
        cm.setMaxTotal(this.clientProperties.getMaximumTotalConnections());
        cm.setDefaultMaxPerRoute(this.clientProperties.getMaximumConnectionsPerHost());
        SocketConfig.Builder socketOptions = SocketConfig.custom();
        if (this.clientProperties.getDefaultSoTimeout() > 0) {
            socketOptions.setSoTimeout(this.clientProperties.getDefaultSoTimeout());
        }
        socketOptions.setTcpNoDelay(true);
        cm.setDefaultSocketConfig(socketOptions.build());
        return cm;
    }

    protected CloseableHttpClient createHttpClient(PoolingHttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setUserAgent("CollabNet Jenkins Plugin").build();
    }

    protected HttpClientContext createHttpContext(MessageContext msgContext, URI uri) {
        HttpClientContext context = new HttpClientContext((HttpContext)new BasicHttpContext());
        String userID = msgContext.getUsername();
        String passwd = msgContext.getPassword();
        if (userID == null && uri.getUserInfo() != null) {
            String info = uri.getUserInfo();
            int sep = info.indexOf(58);
            if (sep >= 0 && sep + 1 < info.length()) {
                userID = info.substring(0, sep);
                passwd = info.substring(sep + 1);
            } else {
                userID = info;
            }
        }
        if (userID != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            int domainIndex = userID.indexOf(92);
            if (domainIndex > 0 && userID.length() > domainIndex + 1) {
                String domain = userID.substring(0, domainIndex);
                String user = userID.substring(domainIndex + 1);
                credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(user, passwd, NetworkUtils.getLocalHostname(), domain));
            } else {
                credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userID, passwd));
            }
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        return context;
    }

    protected HttpUriRequest createHttpRequest(MessageContext msgContext, URI url) throws AxisFault {
        MimeHeaders mimeHeaders;
        String action;
        String webMethod;
        boolean posting = true;
        if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && (webMethod = msgContext.getStrProp("soap12.webmethod")) != null) {
            posting = webMethod.equals("POST");
        }
        HttpPost request = posting ? new HttpPost(url) : new HttpGet(url);
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        Message msg = msgContext.getRequestMessage();
        request.addHeader("Content-Type", msg.getContentType(msgContext.getSOAPConstants()));
        request.addHeader("SOAPAction", "\"" + action + "\"");
        String httpVersion = msgContext.getStrProp("axis.transport.version");
        if (httpVersion != null && httpVersion.equals(HTTPConstants.HEADER_PROTOCOL_V10)) {
            request.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        }
        if ((mimeHeaders = msg.getMimeHeaders()) != null) {
            Iterator i = mimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)i.next();
                String name = mimeHeader.getName();
                if (name.equals("Content-Type") || name.equals("SOAPAction")) continue;
                request.addHeader(name, mimeHeader.getValue());
            }
        }
        boolean isChunked = false;
        boolean isExpectContinueEnabled = false;
        Map userHeaderTable = (Map)msgContext.getProperty("HTTP-Request-Headers");
        if (userHeaderTable != null) {
            for (Map.Entry me : userHeaderTable.entrySet()) {
                Object keyObj = me.getKey();
                if (keyObj == null) continue;
                String key = keyObj.toString().trim();
                String value = me.getValue().toString().trim();
                if (key.equalsIgnoreCase("Expect")) {
                    isExpectContinueEnabled = value.equalsIgnoreCase("100-continue");
                    continue;
                }
                if (key.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
                    isChunked = JavaUtils.isTrue((String)value);
                    continue;
                }
                request.addHeader(key, value);
            }
        }
        RequestConfig.Builder config = RequestConfig.custom();
        if (msgContext.getTimeout() != 0) {
            config.setSocketTimeout(msgContext.getTimeout()).setConnectTimeout(msgContext.getTimeout());
        } else if (this.clientProperties.getConnectionPoolTimeout() != 0) {
            config.setConnectTimeout(this.clientProperties.getConnectionPoolTimeout());
        }
        config.setContentCompressionEnabled(msgContext.isPropertyTrue("transport.http.acceptGzip"));
        config.setExpectContinueEnabled(isExpectContinueEnabled);
        request.setConfig(config.build());
        if (request instanceof HttpPost) {
            MessageEntity requestEntity = new MessageEntity((HttpRequestBase)request, msgContext.getRequestMessage(), isChunked);
            if (msgContext.isPropertyTrue("transport.http.gzipRequest")) {
                requestEntity = new GzipCompressingEntity((HttpEntity)requestEntity);
            }
            request.setEntity((HttpEntity)requestEntity);
        }
        return request;
    }

    protected Message extractResponse(MessageContext msgContext, HttpResponse response) throws IOException {
        int returnCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (!(entity != null && returnCode > 199 && returnCode < 300 || entity != null && msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS || entity != null && returnCode > 499 && returnCode < 600 && Objects.equals(CtfSoapHttpSender.getMimeType(entity), "text/xml"))) {
            String statusMessage = response.getStatusLine().getReasonPhrase();
            AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
            fault.setFaultDetailString("Return code: " + String.valueOf(returnCode) + (entity == null ? "" : "\n" + EntityUtils.toString((HttpEntity)entity)));
            fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE, String.valueOf(returnCode));
            throw fault;
        }
        Header contentLocation = response.getFirstHeader("Content-Location");
        Message outMsg = new Message((Object)entity.getContent(), false, Objects.toString(ContentType.get((HttpEntity)entity), null), contentLocation == null ? null : contentLocation.getValue());
        MimeHeaders responseMimeHeaders = outMsg.getMimeHeaders();
        for (Header responseHeader : response.getAllHeaders()) {
            responseMimeHeaders.addHeader(responseHeader.getName(), responseHeader.getValue());
        }
        outMsg.setMessageType("response");
        return outMsg;
    }

    private static String getMimeType(HttpEntity entity) {
        ContentType contentType = ContentType.get((HttpEntity)entity);
        return contentType == null ? null : contentType.getMimeType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        if (this.httpClient == null) {
            this.init();
        }
        try {
            URI uri = new URI(msgContext.getStrProp("transport.url"));
            HttpClientContext context = msgContext.getMaintainSession() ? this.createHttpContext(msgContext, uri) : this.createHttpContext(msgContext, uri);
            HttpUriRequest request = this.createHttpRequest(msgContext, uri);
            try (CloseableHttpResponse response = null;){
                response = this.httpClient.execute(request, (HttpContext)context);
                Message outMsg = this.extractResponse(msgContext, (HttpResponse)response);
                msgContext.setResponseMessage(outMsg);
                outMsg.getSOAPEnvelope();
            }
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    public static SSLConnectionSocketFactory tryCreateAcceptAllSslSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }}, new SecureRandom());
            return new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            return SSLConnectionSocketFactory.getSocketFactory();
        }
    }

    protected static class MessageEntity
    extends AbstractHttpEntity {
        private final HttpRequestBase method;
        private final Message message;

        public MessageEntity(HttpRequestBase method, Message message, boolean httpChunkStream) {
            this.message = message;
            this.method = method;
            this.setChunked(httpChunkStream);
        }

        protected boolean isContentLengthNeeded() {
            return this.method.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) || !this.isChunked();
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            if (this.isContentLengthNeeded()) {
                try {
                    return this.message.getContentLength();
                }
                catch (AxisFault axisFault) {
                    // empty catch block
                }
            }
            return -1L;
        }

        public InputStream getContent() throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outstream) throws IOException {
            try {
                this.message.writeTo(outstream);
            }
            catch (SOAPException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        public boolean isStreaming() {
            return false;
        }
    }
}

