/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap60.webservices.cemain.ProjectMemberSoapRow;
import com.collabnet.ce.soap60.webservices.cemain.UserGroupSoapList;
import com.collabnet.ce.soap60.webservices.cemain.UserGroupSoapRow;
import com.collabnet.ce.soap60.webservices.cemain.UserSoapDO;
import com.collabnet.ce.soap60.webservices.cemain.UserSoapRow;
import com.collabnet.ce.webservices.CTFGroup;
import com.collabnet.ce.webservices.CTFList;
import com.collabnet.ce.webservices.CTFObject;
import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.ObjectWithTitle;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;

public class CTFUser
extends CTFObject
implements ObjectWithTitle {
    private String userName;
    private String fullName;
    private String email;
    private volatile UserSoapDO data;

    CTFUser(CollabNetApp app, ProjectMemberSoapRow data) {
        super(app, data.getUserName());
        this.userName = data.getUserName();
        this.fullName = data.getFullName();
        this.email = data.getEmail();
    }

    CTFUser(CollabNetApp app, UserSoapDO data) {
        super(app, data.getUsername());
        this.userName = data.getUsername();
        this.fullName = data.getFullName();
        this.email = data.getEmail();
        this.data = data;
    }

    CTFUser(CollabNetApp app, UserSoapRow data) {
        super(app, data.getUserName());
        this.userName = data.getUserName();
        this.fullName = data.getFullName();
        this.email = data.getEmail();
    }

    private UserSoapDO data() throws RemoteException {
        if (this.data == null) {
            this.data = this.app.icns.getUserData(this.app.getSessionId(), this.getId());
        }
        return this.data;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public String getTitle() {
        return this.userName;
    }

    public String getLocale() throws RemoteException {
        return this.data().getLocale();
    }

    public String getTimeZone() throws RemoteException {
        return this.data().getTimeZone();
    }

    public boolean isSuperUser() throws RemoteException {
        return this.data().getSuperUser();
    }

    public boolean isRestrictedUser() throws RemoteException {
        return this.data().getRestrictedUser();
    }

    public String getStatus() throws RemoteException {
        return this.data().getStatus();
    }

    public Set<String> getGroupNames() throws RemoteException {
        HashSet<String> groups = new HashSet<String>();
        UserGroupSoapList gList = this.app.icns.getUserGroupListForUser(this.app.getSessionId(), this.userName);
        for (UserGroupSoapRow row : gList.getDataRows()) {
            groups.add(row.getFullName());
        }
        return groups;
    }

    public CTFList<CTFGroup> getGroups() throws RemoteException {
        CTFList<CTFGroup> groups = new CTFList<CTFGroup>();
        UserGroupSoapList gList = this.app.icns.getUserGroupListForUser(this.app.getSessionId(), this.userName);
        for (UserGroupSoapRow row : gList.getDataRows()) {
            groups.add(this.app.getGroupByTitle(row.getFullName()));
        }
        return groups;
    }

    public void addTo(CTFGroup g) throws RemoteException {
        g.addMember(this);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CTFUser that = (CTFUser)o;
        return this.userName.equals(that.userName);
    }

    public int hashCode() {
        return this.userName.hashCode();
    }
}

