/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap60.webservices.cemain.ProjectMemberSoapRow;
import com.collabnet.ce.soap60.webservices.cemain.ProjectSoapDO;
import com.collabnet.ce.soap60.webservices.cemain.ProjectSoapRow;
import com.collabnet.ce.soap60.webservices.cemain.UserSoapRow;
import com.collabnet.ce.soap60.webservices.docman.DocumentFolderSoapList;
import com.collabnet.ce.soap60.webservices.docman.DocumentFolderSoapRow;
import com.collabnet.ce.soap60.webservices.frs.PackageSoapRow;
import com.collabnet.ce.soap60.webservices.rbac.RoleSoapList;
import com.collabnet.ce.soap60.webservices.rbac.RoleSoapRow;
import com.collabnet.ce.soap60.webservices.scm.RepositorySoapRow;
import com.collabnet.ce.soap60.webservices.tracker.TrackerSoapRow;
import com.collabnet.ce.webservices.CTFDocumentFolder;
import com.collabnet.ce.webservices.CTFList;
import com.collabnet.ce.webservices.CTFObject;
import com.collabnet.ce.webservices.CTFPackage;
import com.collabnet.ce.webservices.CTFRole;
import com.collabnet.ce.webservices.CTFScmRepository;
import com.collabnet.ce.webservices.CTFTracker;
import com.collabnet.ce.webservices.CTFUser;
import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.ObjectWithTitle;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CTFProject
extends CTFObject
implements ObjectWithTitle {
    private final String title;

    CTFProject(CollabNetApp app, ProjectSoapDO data) {
        super(app, data.getId());
        this.title = data.getTitle();
    }

    CTFProject(CollabNetApp app, ProjectSoapRow data) {
        super(app, data.getId());
        this.title = data.getTitle();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public CTFPackage createPackage(String title, String description, boolean isPublished) throws RemoteException {
        return new CTFPackage((CTFObject)this, this.app.getFrsAppSoap().createPackage(this.app.getSessionId(), this.getId(), title, description, isPublished));
    }

    public CTFList<CTFPackage> getPackages() throws RemoteException {
        CTFList<CTFPackage> r = new CTFList<CTFPackage>();
        for (PackageSoapRow row : this.app.getFrsAppSoap().getPackageList(this.app.getSessionId(), this.getId()).getDataRows()) {
            r.add(new CTFPackage((CTFObject)this, row));
        }
        return r;
    }

    public CTFList<CTFTracker> getTrackers() throws RemoteException {
        CTFList<CTFTracker> r = new CTFList<CTFTracker>();
        for (TrackerSoapRow row : this.app.getTrackerSoap().getTrackerList(this.app.getSessionId(), this.getId()).getDataRows()) {
            r.add(new CTFTracker(this, row));
        }
        return r;
    }

    public CTFTracker createTracker(String name, String title, String description) throws RemoteException {
        return new CTFTracker(this, this.app.getTrackerSoap().createTracker(this.app.getSessionId(), this.getId(), name, title, description, null));
    }

    public CTFList<CTFScmRepository> getScmRepositories() throws RemoteException {
        CTFList<CTFScmRepository> r = new CTFList<CTFScmRepository>();
        for (RepositorySoapRow row : this.app.getScmAppSoap().getRepositoryList(this.app.getSessionId(), this.getId()).getDataRows()) {
            r.add(new CTFScmRepository(this, row));
        }
        return r;
    }

    public List<CTFUser> getMembers() throws RemoteException {
        ArrayList<CTFUser> r = new ArrayList<CTFUser>();
        for (ProjectMemberSoapRow row : this.app.icns.getProjectMemberList(this.app.getSessionId(), this.getId()).getDataRows()) {
            r.add(new CTFUser(this.app, row));
        }
        return r;
    }

    public List<CTFUser> getAdmins() throws RemoteException {
        ArrayList<CTFUser> r = new ArrayList<CTFUser>();
        for (UserSoapRow row : this.app.icns.listProjectAdmins(this.app.getSessionId(), this.getId()).getDataRows()) {
            r.add(new CTFUser(this.app, row));
        }
        return r;
    }

    public void addMember(String userName) throws RemoteException {
        this.app.icns.addProjectMember(this.app.getSessionId(), this.getId(), userName);
    }

    public void addMember(CTFUser u) throws RemoteException {
        this.addMember(u.getUserName());
    }

    public boolean hasMember(String username) throws RemoteException {
        for (CTFUser u : this.getMembers()) {
            if (!u.getUserName().equals(username)) continue;
            return true;
        }
        return false;
    }

    public CTFList<CTFRole> getRoles() throws RemoteException {
        return this.toRoleList(this.app.getRbacAppSoap().getRoleList(this.app.getSessionId(), this.getId()));
    }

    public CTFRole createRole(String title, String description) throws RemoteException {
        return new CTFRole(this, this.app.getRbacAppSoap().createRole(this.app.getSessionId(), this.getId(), title, description, false, false, false));
    }

    public CTFList<CTFRole> getUserRoles(CTFUser u) throws RemoteException {
        return this.getUserRoles(u.getUserName());
    }

    public CTFList<CTFRole> getUserRoles(String username) throws RemoteException {
        return this.toRoleList(this.app.getRbacAppSoap().getUserRoleList(this.app.getSessionId(), this.getId(), username));
    }

    private CTFList<CTFRole> toRoleList(RoleSoapList roles) {
        CTFList<CTFRole> r = new CTFList<CTFRole>();
        for (RoleSoapRow row : roles.getDataRows()) {
            r.add(new CTFRole(this, row));
        }
        return r;
    }

    public CTFDocumentFolder getRootFolder() throws RemoteException {
        DocumentFolderSoapList dfsList = this.app.getDocumentAppSoap().getDocumentFolderList(this.app.getSessionId(), this.getId(), false);
        switch (dfsList.getDataRows().length) {
            case 0: {
                throw new CollabNetApp.CollabNetAppException("getRootFolder for projectId " + this.title + " failed to find any folders");
            }
            case 1: {
                return new CTFDocumentFolder((CTFObject)this, dfsList.getDataRows()[0]);
            }
        }
        StringBuilder rowNames = new StringBuilder();
        for (DocumentFolderSoapRow row : dfsList.getDataRows()) {
            rowNames.append(row.getTitle() + ", ");
        }
        throw new CollabNetApp.CollabNetAppException("getRootFolder returned unexpected number of folders: " + rowNames.toString());
    }

    public CTFDocumentFolder getOrCreateDocumentFolder(String documentPath) throws RemoteException {
        CTFDocumentFolder next;
        documentPath = this.normalizePath(documentPath);
        String[] folderNames = documentPath.split("/");
        int i = 0;
        CTFDocumentFolder cur = this.getRootFolder();
        if (cur.getTitle().equals(folderNames[i])) {
            ++i;
        }
        while (i < folderNames.length && (next = cur.getFolders().byTitle(folderNames[i])) != null) {
            cur = next;
            ++i;
        }
        while (i < folderNames.length) {
            cur = cur.createFolder(folderNames[i], folderNames[i]);
            ++i;
        }
        return cur;
    }

    private String normalizePath(String documentPath) {
        if (documentPath.startsWith("/")) {
            documentPath = documentPath.substring(1);
        }
        if (documentPath.endsWith("/")) {
            documentPath = documentPath.substring(0, documentPath.length() - 1);
        }
        return documentPath;
    }

    public String verifyPath(String documentPath) throws RemoteException {
        documentPath = this.normalizePath(documentPath);
        String[] folderNames = documentPath.split("/");
        int i = 0;
        CTFDocumentFolder cur = this.getRootFolder();
        if (cur.getTitle().equals(folderNames[i])) {
            ++i;
        }
        while (i < folderNames.length) {
            CTFDocumentFolder next = cur.getFolders().byTitle(folderNames[i]);
            if (next == null) {
                return folderNames[i];
            }
            cur = next;
            ++i;
        }
        return null;
    }
}

