/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.orchestrate;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.collabnet.orchestrate.BuildToJSON;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;

public class DefaultBuildToJSON
implements BuildToJSON {
    Logger logger = Logger.getLogger("hudson.plugins.collab.orchestrate");

    @Override
    public JSONObject toJson(Object object) throws IOException {
        StringWriter writer = new StringWriter();
        Model model = new ModelBuilder().get(object.getClass());
        model.writeTo(object, Flavor.JSON.createDataWriter(object, (Writer)writer));
        ((Writer)writer).close();
        return JSONObject.fromObject((Object)((Object)writer).toString());
    }

    @Override
    public JSONObject getBuildData(Run run) throws IOException {
        return this.getBuildData(run, null, false);
    }

    @Override
    public JSONObject getBuildData(Run run, String eventqStatus, boolean excludeCommitInfo) throws IOException {
        Run rawBuild;
        Run useRun = run;
        if (!(useRun instanceof AbstractBuild) && (rawBuild = this.getRawBuild(useRun)) != null) {
            useRun = rawBuild;
        }
        JSONObject buildData = new JSONObject().element("remote_id", (Object)String.valueOf(useRun.getNumber())).element("event_time", (Object)this.convertTime(useRun.getTime())).element("build_url", (Object)this.getBuildURL(useRun)).element("status", (Map)this.getStatus(useRun, eventqStatus)).element("test_results", (Object)this.getTestResults(useRun));
        if (!excludeCommitInfo) {
            buildData = buildData.element("revisions", (Object)this.getRevisions(useRun));
        }
        long duration = System.currentTimeMillis() - useRun.getTimeInMillis();
        long duration_s = Math.round((double)duration / 1000.0);
        buildData.put("duration", (Object)String.valueOf(duration_s));
        return buildData;
    }

    @Override
    public URI stripUserAndPassword(String repositoryString) {
        URI repositoryURI;
        try {
            URI fullURI = new URI(repositoryString);
            repositoryURI = new URI(fullURI.getScheme(), null, fullURI.getHost(), fullURI.getPort(), fullURI.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            this.logger.log(Level.SEVERE, "Unable to parse URL", e);
            repositoryURI = null;
        }
        return repositoryURI;
    }

    @Override
    public String convertTime(Date time) {
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
        return dateTimeFormatter.print(time.getTime());
    }

    @Override
    public JSONObject getTestResults(Run run) {
        AbstractTestResultAction testResultAction = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
        if (testResultAction == null) {
            return null;
        }
        int totalCount = testResultAction.getTotalCount();
        int passCount = totalCount - (testResultAction.getFailCount() + testResultAction.getSkipCount());
        return new JSONObject().element("passed_count", passCount).element("failed_count", testResultAction.getFailCount()).element("ignored_count", testResultAction.getSkipCount()).element("url", (Object)this.getTestResultsURL(run, testResultAction));
    }

    @Override
    public JSONObject getStatus(Run run) {
        Result result = run.getResult();
        String eventQStatus = null;
        if (result != null) {
            eventQStatus = result.isBetterOrEqualTo(Result.SUCCESS) ? "success" : (result.isBetterOrEqualTo(Result.UNSTABLE) ? "unstable" : (result == Result.ABORTED ? "aborted" : "fail"));
        }
        return this.getStatus(eventQStatus);
    }

    private JSONObject getStatus(Run run, String statusNameOrType) {
        return statusNameOrType != null && statusNameOrType.trim().length() > 0 ? this.getStatus(statusNameOrType) : this.getStatus(run);
    }

    private JSONObject getStatus(String statusNameOrType) {
        JSONObject status = new JSONObject();
        if (statusNameOrType != null && statusNameOrType.trim().length() > 0) {
            if (statusNameOrType.toLowerCase().startsWith("success")) {
                status.put("type", (Object)"SUCCESS");
                status.put("name", (Object)"Successful");
            } else if (statusNameOrType.toLowerCase().startsWith("unstable")) {
                status.put("type", (Object)"UNSTABLE");
                status.put("name", (Object)"Unstable");
            } else if (statusNameOrType.toLowerCase().startsWith("aborted")) {
                status.put("type", (Object)"ABORTED");
                status.put("name", (Object)"Aborted");
            } else {
                status.put("type", (Object)"FAILURE");
                status.put("name", (Object)"Failed");
            }
        }
        if (!status.has("type")) {
            status.put("type", (Object)"SUCCESS");
            status.put("name", (Object)"Successful");
        }
        return status;
    }

    @Override
    public URI getBuildURI(Run run) throws URISyntaxException {
        return new URI(run.getAbsoluteUrl());
    }

    @Override
    public JSONArray getRevisions(Run run) throws IOException {
        JSONObject repositoryInfo = this.getRepositoryInfo(run);
        if (repositoryInfo == null) {
            return null;
        }
        JSONArray revisions = new JSONArray();
        for (ChangeLogSet.Entry entry : this.findChangeSet(run)) {
            JSONObject revision = new JSONObject();
            revision.putAll((Map)repositoryInfo);
            revision.put("revision", (Object)entry.getCommitId());
            revisions.add((Object)revision);
        }
        return revisions;
    }

    @Override
    public JSONObject getRepositoryInfo(Run run) throws IOException {
        URI repositoryURI;
        String repositoryType;
        SCM scmServer = this.getSCM(run);
        if (scmServer == null) {
            return null;
        }
        String serverType = scmServer.getType();
        if ("hudson.scm.SubversionSCM".equals(serverType)) {
            repositoryType = "svn";
            repositoryURI = this.getSVNRepository(run);
        } else if ("hudson.plugins.git.GitSCM".equals(serverType)) {
            repositoryType = "git";
            repositoryURI = this.getGitRepository(run, scmServer);
        } else {
            this.logger.warning("Unknown repository type " + serverType);
            return null;
        }
        return new JSONObject().element("repository_type", (Object)repositoryType).element("repository_url", (Object)repositoryURI.toString());
    }

    protected URI getSVNRepository(Run run) throws IOException {
        JSONObject changeSet = this.toJson(this.getChangeSet(run));
        JSONObject firstRevision = changeSet.getJSONArray("revisions").getJSONObject(0);
        return this.stripUserAndPassword(firstRevision.getString("module"));
    }

    protected URI getGitRepository(Run run, SCM scm) throws IOException {
        String repositoryString;
        Action buildDataAction = this.getActionByClassName(run, "hudson.plugins.git.util.BuildData");
        if (buildDataAction == null) {
            this.logger.warning("Git plugin not found");
            return null;
        }
        JSONObject actionObject = this.toJson(buildDataAction);
        JSONArray remoteUrls = actionObject.getJSONArray("remoteUrls");
        if (remoteUrls != null && remoteUrls.size() > 0) {
            repositoryString = remoteUrls.getString(0);
        } else {
            this.logger.fine("Falling back to old repository detection.");
            JSONObject scmInfo = this.toJson(scm);
            JSONArray userRemoteConfigs = scmInfo.getJSONArray("userRemoteConfigs");
            repositoryString = userRemoteConfigs.getJSONObject(0).getString("url");
        }
        return this.stripUserAndPassword(repositoryString);
    }

    protected Action getActionByClassName(Run run, String actionName) {
        for (Action action : run.getAllActions()) {
            if (!actionName.equals(action.getClass().getName())) continue;
            return action;
        }
        return null;
    }

    private String getBuildURL(Run run) {
        String buildURL = null;
        try {
            URI buildURI = this.getBuildURI(run);
            buildURL = buildURI.toString();
        }
        catch (URISyntaxException e) {
            this.logger.log(Level.SEVERE, "Failed to parse build URL", e);
        }
        return buildURL;
    }

    private String getTestResultsURL(Run run, AbstractTestResultAction testResultAction) {
        String resultsURL = null;
        try {
            URI uri = this.getBuildURI(run);
            URI testURI = uri.resolve(testResultAction.getUrlName());
            resultsURL = testURI.toString();
        }
        catch (URISyntaxException e) {
            this.logger.log(Level.SEVERE, "Unable to parse URL", e);
        }
        return resultsURL;
    }

    private ChangeLogSet<? extends ChangeLogSet.Entry> findChangeSet(Run run) {
        ChangeLogSet<? extends ChangeLogSet.Entry> cs = this.getChangeSet(run);
        if (run != null && cs.isEmptySet()) {
            return this.findChangeSet(run.getPreviousBuild());
        }
        return cs;
    }

    private ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet(Run run) {
        List changeSets;
        if (run == null) {
            return ChangeLogSet.createEmpty((Run)run);
        }
        if (run instanceof AbstractBuild) {
            return ((AbstractBuild)run).getChangeSet();
        }
        if (run instanceof WorkflowRun && !(changeSets = ((WorkflowRun)run).getChangeSets()).isEmpty()) {
            return (ChangeLogSet)changeSets.get(changeSets.size() - 1);
        }
        try {
            changeSets = (List)run.getClass().getMethod("getChangeSets", new Class[0]).invoke((Object)run, new Object[0]);
            if (changeSets != null && !changeSets.isEmpty()) {
                for (ChangeLogSet clEntry : changeSets) {
                    if (clEntry.isEmptySet()) continue;
                    return clEntry;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ChangeLogSet.createEmpty((Run)run);
    }

    private SCM getSCM(Run build) {
        SCM scmServer = null;
        if (build.getParent() instanceof AbstractProject) {
            scmServer = ((AbstractProject)build.getParent()).getScm();
        } else if (build.getParent() instanceof WorkflowJob) {
            WorkflowJob parentWJ = (WorkflowJob)build.getParent();
            scmServer = parentWJ.getTypicalSCM();
        }
        if (scmServer == null) {
            this.logger.warning("Failed to get repository info for " + build.getId());
        }
        return scmServer;
    }

    private Run getRawBuild(Run build) {
        Run rawBuild = null;
        try {
            rawBuild = Run.fromExternalizableId((String)build.getExternalizableId());
        }
        catch (Exception e) {
            this.logger.warning("Failed to get raw build for " + (build == null ? "???" : Integer.valueOf(build.getNumber())));
        }
        return rawBuild;
    }
}

