/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.browser;

import com.collabnet.ce.webservices.CollabNetApp;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.collabnet.ConnectionFactory;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TeamForge
extends SubversionRepositoryBrowser {
    private static Logger log = Logger.getLogger("TeamForge");
    private String collabneturl;
    private String username;
    private Secret password;
    private String project;
    private String repo;
    private boolean overrideAuth;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public TeamForge(ConnectionFactory connectionFactory, String project, String repo) {
        if (connectionFactory != null) {
            this.overrideAuth = true;
            this.collabneturl = connectionFactory.getUrl();
            this.username = connectionFactory.getUsername();
            this.password = connectionFactory.getPassword();
        } else {
            this.overrideAuth = false;
        }
        this.project = project;
        this.repo = repo;
    }

    public TeamForge(String collabneturl, String username, String password, String project, String repo, boolean overrideAuth) {
        this.collabneturl = CNHudsonUtil.sanitizeCollabNetUrl(collabneturl);
        this.username = username;
        this.password = Secret.fromString((String)password);
        this.project = project;
        this.repo = repo;
        this.overrideAuth = overrideAuth;
    }

    public TeamForge(String project, String repo, boolean overrideAuth) {
        this(null, null, null, project, repo, overrideAuth);
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean overrideAuth() {
        return this.overrideAuth;
    }

    public String getCollabNetUrl() {
        if (this.overrideAuth()) {
            return this.collabneturl;
        }
        return TeamForge.getTeamForgeShareDescriptor().getCollabNetUrl();
    }

    public String getUsername() {
        if (this.overrideAuth()) {
            return this.username;
        }
        return TeamForge.getTeamForgeShareDescriptor().getUsername();
    }

    public String getPassword() {
        if (this.overrideAuth()) {
            return Secret.toString((Secret)this.password);
        }
        return TeamForge.getTeamForgeShareDescriptor().getPassword();
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.overrideAuth()) {
            return new ConnectionFactory(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        }
        return null;
    }

    public String getProject() {
        return this.project;
    }

    public String getRepo() {
        return this.repo;
    }

    public static TeamForgeShare.TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        return TeamForgeShare.getTeamForgeShareDescriptor();
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        StringBuffer link = this.getViewerUrlWithPath(path).append("&system=").append(this.getSystemId()).append("&view=markup");
        return new URL(link.toString());
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        int revision = path.getLogEntry().getRevision();
        int r1 = revision - 1;
        int r2 = revision;
        StringBuffer link = this.getViewerUrlWithPath(path).append("&system=").append(this.getSystemId()).append("&r1=").append(r1).append("&r2=").append(r2);
        return new URL(link.toString());
    }

    private StringBuffer getViewerUrlWithPath(SubversionChangeLogSet.Path path) throws RemoteException {
        String[] urlParts = this.getViewerUrl().split("\\?");
        StringBuffer viewWithPath = new StringBuffer(urlParts[0]).append(path.getValue()).append("?");
        if (urlParts.length > 1) {
            viewWithPath.append(urlParts[1]);
        }
        return viewWithPath;
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        int revision = changeSet.getRevision();
        StringBuffer link = new StringBuffer(this.getViewerUrl()).append("?view=revision&system=").append(this.getSystemId()).append("&revision=").append(revision);
        return new URL(link.toString());
    }

    private String getViewerUrl() throws RemoteException {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        return CNHudsonUtil.getScmViewerUrl(cna, this.getCollabNetUrl(), this.getProject(), this.getRepo());
    }

    private String getSystemId() throws RemoteException {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        return CNHudsonUtil.getSystemId(cna, this.getProject(), this.getRepo());
    }

    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public DescriptorImpl() {
            super(TeamForge.class);
        }

        public String getDisplayName() {
            return "Collabnet TeamForge";
        }

        public static String getHelpUrl() {
            return "/plugin/collabnet/browser/";
        }

        public String getHelpFile() {
            return DescriptorImpl.getHelpUrl() + "help.html";
        }

        public boolean canInheritAuth() {
            return TeamForge.getTeamForgeShareDescriptor().useGlobal();
        }

        public FormValidation doCheckProject(CollabNetApp app, @QueryParameter String value) throws RemoteException {
            return CNFormFieldValidator.projectCheck(app, value);
        }

        public FormValidation doCheckRepo(StaplerRequest req) throws RemoteException {
            return CNFormFieldValidator.repoCheck(req);
        }

        public ComboBoxModel doFillProjectItems(CollabNetApp cna) throws IOException {
            ComboBoxModel projects = ComboBoxUpdater.getProjectList(cna);
            CNHudsonUtil.logoff(cna);
            return projects;
        }

        public ComboBoxModel doFillRepoItems(CollabNetApp cna, @QueryParameter String project) throws RemoteException {
            ComboBoxModel repos = ComboBoxUpdater.getRepos(cna, project);
            CNHudsonUtil.logoff(cna);
            return repos;
        }
    }
}

