/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CollabNetApp;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractItem;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.User;
import hudson.model.View;
import hudson.plugins.collabnet.auth.CNAuthProjectProperty;
import hudson.plugins.collabnet.auth.CNAuthenticatedUserACL;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CNRootACL;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.util.FormValidation;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CNAuthorizationStrategy
extends AuthorizationStrategy {
    private Collection<String> readUsers;
    private Collection<String> readGroups;
    private Collection<String> adminUsers;
    private Collection<String> adminGroups;
    private int mAuthCacheTimeoutMin;
    private volatile ACL rootACL;
    private static Logger log = Logger.getLogger("CNAuthorizationStrategy");

    public CNAuthorizationStrategy(List<String> readUsers, List<String> readGroups, List<String> adminUsers, List<String> adminGroups, int permCacheTimeoutMin) {
        this.readUsers = new ArrayList<String>(readUsers);
        this.readGroups = new ArrayList<String>(readGroups);
        this.adminUsers = new ArrayList<String>(adminUsers);
        this.adminGroups = new ArrayList<String>(adminGroups);
        this.mAuthCacheTimeoutMin = Math.max(0, permCacheTimeoutMin);
        this.rootACL = new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups);
    }

    @DataBoundConstructor
    public CNAuthorizationStrategy(String readUsersStr, String readGroupsStr, String adminUsersStr, String adminGroupsStr, int authCacheTimeoutMin) {
        this(CommonUtil.splitCommaStr(readUsersStr), CommonUtil.splitCommaStr(readGroupsStr), CommonUtil.splitCommaStr(adminUsersStr), CommonUtil.splitCommaStr(adminGroupsStr), Math.max(0, authCacheTimeoutMin));
    }

    public String getReadUsersStr() {
        return Util.join(this.readUsers, (String)", ");
    }

    public String getReadGroupsStr() {
        return Util.join(this.readGroups, (String)", ");
    }

    public String getAdminUsersStr() {
        return Util.join(this.adminUsers, (String)", ");
    }

    public String getAdminGroupsStr() {
        return Util.join(this.adminGroups, (String)", ");
    }

    public int getAuthCacheTimeoutMin() {
        return this.mAuthCacheTimeoutMin;
    }

    public long getAuthCacheTimeoutMs() {
        return (long)this.getAuthCacheTimeoutMin() * 60000L;
    }

    public Collection<String> getGroups() {
        return CNProjectACL.CollabNetRoles.getNames();
    }

    public ACL getRootACL() {
        if (this.rootACL == null) {
            this.rootACL = new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups);
        }
        return this.rootACL;
    }

    public ACL getACL(Job<?, ?> job) {
        String projectId;
        CNAuthProjectProperty capp = (CNAuthProjectProperty)job.getProperty(CNAuthProjectProperty.class);
        if (capp != null && (projectId = capp.getProjectId()) != null && !projectId.equals("")) {
            return new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups, new CNProjectACL(projectId));
        }
        return new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups, new CNAuthenticatedUserACL());
    }

    public ACL getACL(AbstractItem item) {
        return this.getRootACL();
    }

    public ACL getACL(View view) {
        return this.getRootACL();
    }

    public ACL getACL(Computer computer) {
        return this.getRootACL();
    }

    public ACL getACL(User user) {
        return this.getRootACL();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        public static String GOOD_VERSION = "5.2.0.0";

        public String getDisplayName() {
            return "CollabNet Authorization";
        }

        public static String getCollabNetUrl() {
            CollabNetApp conn = CNConnection.getInstance();
            if (conn == null) {
                return null;
            }
            return conn.getServerUrl();
        }

        public static VersionNumber getVersion(String url) {
            String version;
            if (url == null) {
                return null;
            }
            try {
                version = CollabNetApp.getApiVersion(url);
            }
            catch (RemoteException re) {
                log.info("getVersion: failed with RemoteException: " + re.getMessage());
                return null;
            }
            try {
                return new VersionNumber(version);
            }
            catch (IllegalArgumentException iae) {
                log.severe("getVersion: unexpected error when attempting to parse CollabNet version: " + iae.getMessage());
                return null;
            }
        }

        public static boolean isGoodCNVersion(String url) {
            VersionNumber version = DescriptorImpl.getVersion(url);
            if (version == null) {
                return true;
            }
            VersionNumber desiredVersion = new VersionNumber(GOOD_VERSION);
            return version.compareTo(desiredVersion) >= 0;
        }

        public void doVersionCheck(StaplerRequest req, StaplerResponse rsp, @QueryParameter String url) throws IOException {
            rsp.setContentType("text/plain;charset=UTF-8");
            JSONObject versionJSON = new JSONObject();
            String error_display_style = "none";
            if (!DescriptorImpl.isGoodCNVersion(url)) {
                error_display_style = "inline";
            }
            versionJSON.element("error_display_style", (Object)error_display_style);
            VersionNumber version = DescriptorImpl.getVersion(url);
            if (version != null) {
                versionJSON.element("version", (Object)version.toString());
            } else {
                versionJSON.element("version", (Object)"unknown");
            }
            rsp.getWriter().print(versionJSON.toString());
        }

        public FormValidation doCheckAdminUsersStr(@QueryParameter String value) throws RemoteException {
            return CNFormFieldValidator.userListCheck(value);
        }

        public FormValidation doCheckReadUsersStr(@QueryParameter String value) throws RemoteException {
            return CNFormFieldValidator.userListCheck(value);
        }

        public FormValidation doCheckAdminGroupsStr(@QueryParameter String groups, @QueryParameter String users) throws RemoteException {
            return CNFormFieldValidator.groupListCheck(Util.fixNull((String)groups), Util.fixNull((String)users));
        }

        public FormValidation doCheckReadGroupsStr(@QueryParameter String value) throws RemoteException {
            return CNFormFieldValidator.groupListCheck(value, null);
        }

        public FormValidation doCheckAuthCacheTimeoutMin(@QueryParameter String value) {
            return CNFormFieldValidator.numberCheck(value, true, true, false);
        }
    }
}

