/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CTFList;
import com.collabnet.ce.webservices.CTFRole;
import com.collabnet.ce.webservices.CollabNetApp;
import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CNAuthorizationStrategy;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CollabNetRole;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CNAuthorizationCache {
    private Map<String, Set<Permission>> mPermSetMap = new HashMap<String, Set<Permission>>();
    private long mCacheExpirationDate = System.currentTimeMillis();
    private static final Logger LOGGER = Logger.getLogger(CNAuthorizationCache.class.getName());

    private void clearCache() {
        this.mPermSetMap.clear();
        AuthorizationStrategy authStrategy = Hudson.getInstance().getAuthorizationStrategy();
        CNAuthorizationStrategy cnAuthStrategy = (CNAuthorizationStrategy)authStrategy;
        long permCacheTimeoutMs = cnAuthStrategy.getAuthCacheTimeoutMs();
        this.mCacheExpirationDate = System.currentTimeMillis() + permCacheTimeoutMs;
    }

    public synchronized Set<Permission> getUserProjectPermSet(String username, String projectId) {
        String cacheKey;
        Set<Permission> userPermSet;
        if (System.currentTimeMillis() >= this.mCacheExpirationDate) {
            this.clearCache();
        }
        if ((userPermSet = this.mPermSetMap.get(cacheKey = projectId + ":" + username)) == null) {
            userPermSet = new HashSet<Permission>();
            try {
                CollabNetApp conn = CNConnection.getInstance();
                CTFList<CTFRole> roleNameSet = conn.getProjectById(projectId).getUserRoles(username);
                Collection<CollabNetRole> userRoles = CNProjectACL.CollabNetRoles.getMatchingRoles(roleNameSet);
                for (CollabNetRole role : userRoles) {
                    userPermSet.addAll(role.getPermissions());
                }
            }
            catch (RemoteException e) {
                LOGGER.log(Level.WARNING, "Failed to retrieve permissions for the user " + username + " on " + projectId);
            }
            this.mPermSetMap.put(cacheKey, userPermSet);
        }
        return userPermSet;
    }
}

