/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.actionhub;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.tools.json.JSONReader;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.plugins.collabnet.actionhub.BuildCause;
import hudson.plugins.collabnet.actionhub.MQConnectionHandler;
import hudson.plugins.collabnet.actionhub.Tagger;
import hudson.plugins.collabnet.actionhub.Util;
import hudson.plugins.collabnet.actionhub.Workflow;
import hudson.plugins.collabnet.actionhub.WorkflowParameter;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.security.SecurityRealm;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ActionHubPlugin
extends Builder {
    private static final Logger log = Logger.getLogger(ActionHubPlugin.class.getName());
    static Channel channel = null;
    static Connection connection = null;
    static Consumer workflowMsgConsumer = null;
    static Consumer actionsMsgConsumer = null;
    static MQConnectionHandler shutDownListener = null;
    private static final Jenkins jenkins = Jenkins.getInstance();

    @DataBoundConstructor
    public ActionHubPlugin() {
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void init() {
        boolean reConnectSuccess = true;
        int tries = 0;
        do {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            log.info("Now going to try to connect to Rabbit.");
            reConnectSuccess = true;
            try {
                ActionHubPlugin.connectAndListen();
            }
            catch (IOException ioe) {
                reConnectSuccess = false;
            }
            catch (TimeoutException te) {
                reConnectSuccess = false;
            }
        } while (!reConnectSuccess && ++tries < 5);
        if (!reConnectSuccess) {
            log.info("Unable to connect to Rabbit. Giving up. Check if Rabbit instance is up, then restart Jenkins.");
        }
    }

    public static void connectAndListen() throws IOException, TimeoutException {
        TeamForgeShare.TeamForgeShareDescriptor descriptor;
        if (connection != null && connection.isOpen() && connection.getClientProvidedName() == "CollabNetActionHub") {
            log.info("Closing the connection");
            connection.removeShutdownListener((ShutdownListener)shutDownListener);
            connection.close();
        }
        if ((descriptor = TeamForgeShare.getTeamForgeShareDescriptor()) != null && descriptor.areActionHubSettingsValid()) {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setHost(descriptor.getActionHubMqHost().trim());
            factory.setPort(descriptor.getActionHubMqPort());
            factory.setUsername(descriptor.getActionHubMqUsername().trim());
            factory.setPassword(descriptor.getActionHubMqPassword().trim());
            connection = factory.newConnection("CollabNetActionHub");
            shutDownListener = new MQConnectionHandler();
            connection.addShutdownListener((ShutdownListener)shutDownListener);
            channel = connection.createChannel();
            log.info("Opening a new connection with " + descriptor.getActionHubMqHost() + ":" + descriptor.getActionHubMqPort() + " on exchange " + descriptor.getActionHubMqExchange() + ". Actions Routing key is " + descriptor.getActionHubMqActionsQueue() + ". Workflow Routing key is " + descriptor.getActionHubMqWorkflowQueue());
            ActionHubPlugin.initWorkflowQueueListener(descriptor.getActionHubMqExchange().trim(), descriptor.getActionHubMqWorkflowQueue().trim());
            ActionHubPlugin.initActionsQueueListener(descriptor.getActionHubMqExchange().trim(), descriptor.getActionHubMqActionsQueue().trim());
        } else {
            log.info("Error: Unable to listen on queue. Check ActionHub connection settings.");
        }
    }

    public static void initWorkflowQueueListener(String exchange, String routingKey) throws IOException {
        channel.exchangeDeclare(exchange, "topic", true, false, false, null);
        String queueName = channel.queueDeclare().getQueue();
        channel.queueBind(queueName, exchange, routingKey);
        workflowMsgConsumer = new DefaultConsumer(channel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                String message = "";
                try {
                    message = new String(body, "UTF-8");
                    log.info("Received : " + message + " on " + envelope.getRoutingKey());
                }
                catch (IOException e) {
                    log.info("Could not read workflow message from queue: " + e.getMessage());
                }
                JSONReader jsonParser = new JSONReader();
                Map request = (Map)jsonParser.read(message);
                String passedInWorkFlowId = (String)request.get("workflowId");
                if (jenkins != null) {
                    ActionHubPlugin.authenticate();
                    List buildableItemList = jenkins.getAllItems(BuildableItem.class);
                    boolean found = false;
                    if (buildableItemList != null) {
                        for (BuildableItem buildItem : buildableItemList) {
                            AbstractProject project;
                            if (!buildItem.getFullName().equals(passedInWorkFlowId)) continue;
                            found = true;
                            boolean buildKickoff = false;
                            HashMap ruleInformation = (HashMap)request.get("ruleInformation");
                            BuildCause cause = new BuildCause(envelope.getRoutingKey(), ruleInformation);
                            ArrayList passedInParameters = (ArrayList)request.get("workflowArguments");
                            ArrayList<StringParameterValue> parameters = new ArrayList<StringParameterValue>();
                            if (passedInParameters != null) {
                                for (HashMap passedInParameter : passedInParameters) {
                                    String name = (String)passedInParameter.get("name");
                                    String value = (String)passedInParameter.get("value");
                                    parameters.add(new StringParameterValue(name, value));
                                }
                            }
                            ParametersAction paramAction = new ParametersAction(parameters);
                            if (buildItem instanceof AbstractProject) {
                                project = (AbstractProject)buildItem;
                                buildKickoff = project.scheduleBuild(0, (Cause)cause, new Action[]{paramAction});
                            } else if (buildItem instanceof WorkflowJob) {
                                log.info("This is a Pipeline job");
                                project = (WorkflowJob)buildItem;
                                CauseAction causeAction = new CauseAction((Cause)cause);
                                project.scheduleBuild2(0, new Action[]{paramAction, causeAction});
                                buildKickoff = true;
                            } else {
                                buildKickoff = buildItem.scheduleBuild(0, (Cause)cause);
                            }
                            if (!buildKickoff) break;
                            log.info("Now building: " + buildItem.getFullName());
                            break;
                        }
                        if (!found) {
                            log.info("Could not find that Project.");
                        }
                    } else {
                        log.info("The list was null. No buildable items found.");
                    }
                } else {
                    log.info("Error: Jenkins was null.");
                }
            }
        };
        channel.basicConsume(queueName, true, workflowMsgConsumer);
        log.info("Waiting for workflow messages ...");
    }

    public static void initActionsQueueListener(String exchange, String routingKey) throws IOException {
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("x-message-ttl", 60000);
        channel.exchangeDeclare(exchange, "topic", true, false, false, args);
        String queueName = channel.queueDeclare().getQueue();
        channel.queueBind(queueName, exchange, routingKey);
        actionsMsgConsumer = new DefaultConsumer(channel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                String message = "";
                String jsonResponse = "";
                try {
                    message = new String(body, "UTF-8");
                    log.info("Received : " + message + " on " + envelope.getRoutingKey());
                }
                catch (IOException e) {
                    log.info("Could not read action request from queue: " + e.getMessage());
                }
                JSONReader jsonParser = new JSONReader();
                Map request = (Map)jsonParser.read(message);
                String requestType = (String)request.get("requestType");
                if (requestType.equals("Heartbeat")) {
                    jsonResponse = "{\"OK\"}";
                } else if (requestType.equals("GetActions")) {
                    String messageType = (String)request.get("messageType");
                    Set itemList = ActionHubPlugin.prepareJobList(messageType);
                    ArrayList<Workflow> workflows = new ArrayList<Workflow>();
                    for (Job item : itemList) {
                        if (!(item instanceof BuildableItem)) continue;
                        String buildId = item.getFullName();
                        String buildName = item.getName();
                        String buildDescription = item.getDescription();
                        String configurationUrl = item.getAbsoluteUrl() + "configure";
                        HashMap<String, WorkflowParameter> buildParametersMap = new HashMap<String, WorkflowParameter>();
                        ParametersDefinitionProperty definitions = (ParametersDefinitionProperty)item.getProperty(ParametersDefinitionProperty.class);
                        if (definitions != null) {
                            List parameters = definitions.getParameterDefinitions();
                            for (ParameterDefinition parameter : parameters) {
                                Object defaultValObj;
                                String paramName = parameter.getName();
                                String paramDescription = parameter.getDescription();
                                String paramType = "";
                                String[] paramChoices = new String[]{};
                                if (parameter instanceof StringParameterDefinition) {
                                    paramType = "string";
                                } else if (parameter instanceof ChoiceParameterDefinition) {
                                    paramType = "enum";
                                    List choiceList = ((ChoiceParameterDefinition)parameter).getChoices();
                                    paramChoices = choiceList.toArray(new String[choiceList.size()]);
                                }
                                String paramDefaultValue = "";
                                ParameterValue defaultVal = parameter.getDefaultParameterValue();
                                if (defaultVal != null && (defaultValObj = defaultVal.getValue()) != null) {
                                    paramDefaultValue = defaultValObj.toString();
                                }
                                WorkflowParameter paramAttributes = new WorkflowParameter(paramDescription, paramType, paramDefaultValue, paramChoices);
                                buildParametersMap.put(paramName, paramAttributes);
                            }
                        }
                        Workflow workflow = new Workflow(buildName, buildId, buildDescription, configurationUrl, buildParametersMap);
                        workflows.add(workflow);
                    }
                    try {
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
                        jsonResponse = mapper.writeValueAsString(workflows);
                    }
                    catch (JsonProcessingException e) {
                        log.info("Could not make json response: " + e.getMessage());
                    }
                }
                String replyto = properties.getReplyTo();
                AMQP.BasicProperties props = new AMQP.BasicProperties();
                try {
                    log.info("Replying on " + replyto + " with response: " + jsonResponse);
                    channel.basicPublish("", replyto, props, jsonResponse.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    log.info("Could not process return json: " + e.getMessage());
                }
            }
        };
        channel.basicConsume(queueName, true, actionsMsgConsumer);
        log.info("Waiting for actions requests ...");
    }

    private static void authenticate() {
        GrantedAuthority[] authorities = new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY};
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"ActionHubPlugin", (Object)"", authorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
    }

    private static Set<Job> prepareJobList(String requestMessage) {
        HashSet<Job> returnList = new HashSet<Job>();
        TeamForgeShare.TeamForgeShareDescriptor descriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        boolean respondToGetActionsMessage = Util.respondsTo(descriptor.getActionHubMsgIncludeRadio(), descriptor.isActionHubMsgManual(), descriptor.isActionHubMsgBuild(), descriptor.isActionHubMsgCommit(), descriptor.isActionHubMsgWorkitem(), descriptor.isActionHubMsgReview(), descriptor.isActionHubMsgCustom(), descriptor.getActionHubMsgCustomTxt(), requestMessage);
        if (jenkins != null) {
            ActionHubPlugin.authenticate();
            List itemList = jenkins.getAllItems(Job.class);
            if (itemList != null) {
                if (respondToGetActionsMessage) {
                    for (Job item : itemList) {
                        returnList.add(item);
                    }
                }
                for (Job item : itemList) {
                    Map props = item.getProperties();
                    for (JobProperty value : props.values()) {
                        Tagger tagger;
                        if (!(value instanceof Tagger) || !(tagger = (Tagger)value).isGlobalOverride()) continue;
                        if (tagger.respondsTo(requestMessage)) {
                            returnList.add(item);
                            continue;
                        }
                        returnList.remove(item);
                    }
                }
            }
        } else {
            log.info("Sorry Jenkins was null.");
        }
        return returnList;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return false;
        }

        public String getDisplayName() {
            return "CollabNet ActionHub Plugin";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

