/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap60.fault.NoSuchObjectFault;
import com.collabnet.ce.soap60.webservices.ClientSoapStubFactory;
import com.collabnet.ce.soap60.webservices.cemain.ICollabNetSoap;
import com.collabnet.ce.soap60.webservices.cemain.ProjectSoapRow;
import com.collabnet.ce.soap60.webservices.cemain.UserGroupSoapList;
import com.collabnet.ce.soap60.webservices.cemain.UserGroupSoapRow;
import com.collabnet.ce.soap60.webservices.cemain.UserSoapList;
import com.collabnet.ce.soap60.webservices.cemain.UserSoapRow;
import com.collabnet.ce.soap60.webservices.docman.IDocumentAppSoap;
import com.collabnet.ce.soap60.webservices.filestorage.IFileStorageAppSoap;
import com.collabnet.ce.soap60.webservices.filestorage.ISimpleFileStorageAppSoap;
import com.collabnet.ce.soap60.webservices.frs.IFrsAppSoap;
import com.collabnet.ce.soap60.webservices.rbac.IRbacAppSoap;
import com.collabnet.ce.soap60.webservices.scm.IScmAppSoap;
import com.collabnet.ce.soap60.webservices.tracker.ITrackerAppSoap;
import com.collabnet.ce.webservices.CTFFile;
import com.collabnet.ce.webservices.CTFGroup;
import com.collabnet.ce.webservices.CTFList;
import com.collabnet.ce.webservices.CTFProject;
import com.collabnet.ce.webservices.CTFUser;
import com.collabnet.ce.webservices.TrustAllSocketFactory;
import hudson.RelativePath;
import hudson.plugins.collabnet.share.TeamForgeShare;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.axis.AxisFault;
import org.kohsuke.stapler.QueryParameter;

public class CollabNetApp {
    public static String SOAP_SERVICE = "/ce-soap60/services/";
    public static final int UPLOAD_FILE_CHUNK_SIZE = 780000;
    public static final long MAX_FILE_STORAGE_APP_UPLOAD_SIZE = 0x7C00000L;
    private String sessionId;
    private String username;
    private String url;
    protected final ICollabNetSoap icns;
    private volatile IFrsAppSoap ifrs;
    private volatile IFileStorageAppSoap ifsa;
    private volatile ISimpleFileStorageAppSoap isfsa;
    private volatile ITrackerAppSoap itas;
    private volatile IDocumentAppSoap idas;
    private volatile IScmAppSoap isas;
    private volatile IRbacAppSoap iras;
    public static boolean disableSSLCertificateCheck = false;

    public CollabNetApp(String url, String username, String password) throws RemoteException {
        this(url, username);
        this.sessionId = this.login(password);
    }

    public CollabNetApp(String url, String username, String password, String sessionId) {
        this(url, username);
        this.sessionId = sessionId;
    }

    public CollabNetApp(String url, String username) {
        this(url);
        this.username = username;
    }

    public CollabNetApp(String url) {
        this.url = url;
        this.icns = this.getICollabNetSoap();
        if (disableSSLCertificateCheck) {
            CollabNetApp.disableSSLCertificateCheck();
        }
    }

    private <T> T createProxy(Class<T> type, String wsdlLoc) {
        String soapURL = this.getServerUrl() + SOAP_SERVICE + wsdlLoc + "?wsdl";
        return type.cast(ClientSoapStubFactory.getSoapStub(type, (String)soapURL));
    }

    protected ITrackerAppSoap getTrackerSoap() {
        if (this.itas == null) {
            this.itas = this.createProxy(ITrackerAppSoap.class, "TrackerApp");
        }
        return this.itas;
    }

    protected IDocumentAppSoap getDocumentAppSoap() {
        if (this.idas == null) {
            this.idas = this.createProxy(IDocumentAppSoap.class, "DocumentApp");
        }
        return this.idas;
    }

    protected IScmAppSoap getScmAppSoap() {
        if (this.isas == null) {
            this.isas = this.createProxy(IScmAppSoap.class, "ScmApp");
        }
        return this.isas;
    }

    protected IRbacAppSoap getRbacAppSoap() {
        if (this.iras == null) {
            this.iras = this.createProxy(IRbacAppSoap.class, "RbacApp");
        }
        return this.iras;
    }

    protected IFrsAppSoap getFrsAppSoap() {
        if (this.ifrs == null) {
            this.ifrs = this.createProxy(IFrsAppSoap.class, "FrsApp");
        }
        return this.ifrs;
    }

    protected IFileStorageAppSoap getFileStorageAppSoap() {
        if (this.ifsa == null) {
            this.ifsa = this.createProxy(IFileStorageAppSoap.class, "FileStorageApp");
        }
        return this.ifsa;
    }

    protected ISimpleFileStorageAppSoap getSimpleFileStorageAppSoap() {
        if (this.isfsa == null) {
            this.isfsa = this.createProxy(ISimpleFileStorageAppSoap.class, "SimpleFileStorageAppSoap");
        }
        return this.isfsa;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getServerUrl() {
        return this.url;
    }

    private ICollabNetSoap getICollabNetSoap() {
        return CollabNetApp.getICollabNetSoap(this.url);
    }

    private static ICollabNetSoap getICollabNetSoap(String url) {
        String soapURL = url + SOAP_SERVICE + "CollabNet?wsdl";
        return (ICollabNetSoap)ClientSoapStubFactory.getSoapStub(ICollabNetSoap.class, (String)soapURL);
    }

    private String login(String password) throws RemoteException {
        this.sessionId = this.icns.login(this.username, password);
        return this.sessionId;
    }

    private byte[] getFirstNBytesOfBuffer(byte[] buffer, int n) {
        if (buffer.length == n) {
            return buffer;
        }
        return Arrays.copyOfRange(buffer, 0, n);
    }

    public void loginWithToken(String token) throws RemoteException {
        this.sessionId = this.icns.loginWithToken(this.username, token);
    }

    public void logoff() throws RemoteException {
        this.checkValidSessionId();
        this.icns.logoff(this.username, this.sessionId);
        this.sessionId = null;
    }

    public CTFFile upload(DataHandler src) throws RemoteException {
        return new CTFFile(this, this.getFileStorageAppSoap().uploadFile(this.getSessionId(), src));
    }

    public CTFFile uploadLargeFile(File src) throws RemoteException {
        String fieldId = this.getSimpleFileStorageAppSoap().startFileUpload(this.getSessionId());
        byte[] buffer = new byte[780000];
        try {
            int count;
            InputStream fileInputStream = new FileDataSource(src).getInputStream();
            while ((count = fileInputStream.read(buffer)) != -1) {
                this.getSimpleFileStorageAppSoap().write(this.getSessionId(), fieldId, this.getFirstNBytesOfBuffer(buffer, count));
            }
            this.getSimpleFileStorageAppSoap().endFileUpload(this.getSessionId(), fieldId);
            fileInputStream.close();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return new CTFFile(this, fieldId);
    }

    public CTFFile upload(File src) throws RemoteException {
        if (src.length() > 0x7C00000L) {
            return this.uploadLargeFile(src);
        }
        return this.upload(new DataHandler((DataSource)new FileDataSource(src)));
    }

    public static String getApiVersion(String url) throws RemoteException {
        return CollabNetApp.getICollabNetSoap(url).getApiVersion();
    }

    public String getApiVersion() throws RemoteException {
        return this.icns.getApiVersion();
    }

    public String getVersion() throws RemoteException {
        this.checkValidSessionId();
        return this.icns.getVersion(this.sessionId);
    }

    public boolean isUsernameValid(String username) throws RemoteException {
        this.checkValidSessionId();
        return this.getUser(username) != null;
    }

    public CTFList<CTFGroup> getGroups() throws RemoteException {
        this.checkValidSessionId();
        CTFList<CTFGroup> r = new CTFList<CTFGroup>();
        UserGroupSoapList gsList = this.icns.getUserGroupList(this.sessionId);
        for (UserGroupSoapRow row : gsList.getDataRows()) {
            r.add(new CTFGroup(this, row));
        }
        return r;
    }

    public CTFGroup getGroupByTitle(String fullName) throws RemoteException {
        return this.getGroups().byTitle(fullName);
    }

    public CTFGroup createGroup(String fullName, String description) throws RemoteException {
        return new CTFGroup(this, this.icns.createUserGroup(this.getSessionId(), fullName, description));
    }

    public String createProject(String name, String title, String description) throws RemoteException {
        return this.icns.createProject(this.sessionId, name, title, description).getId();
    }

    public Collection<String> getGroupUsers(String groupId) throws RemoteException {
        this.checkValidSessionId();
        ArrayList<String> users = new ArrayList<String>();
        UserSoapList usList = this.icns.getUserGroupMembers(this.sessionId, groupId);
        for (UserSoapRow row : usList.getDataRows()) {
            users.add(row.getUserName());
        }
        return users;
    }

    public void checkValidSessionId() {
        if (this.sessionId == null) {
            throw new CollabNetAppException("Not currently in a valid session.");
        }
    }

    public CTFProject getProjectById(String projectId) throws RemoteException {
        return new CTFProject(this, this.icns.getProjectData(this.sessionId, projectId));
    }

    public List<CTFProject> getProjects() throws RemoteException {
        ArrayList<CTFProject> r = new ArrayList<CTFProject>();
        boolean fetchHierarchyPath = false;
        for (ProjectSoapRow row : this.icns.getProjectList(this.getSessionId(), fetchHierarchyPath).getDataRows()) {
            r.add(new CTFProject(this, row));
        }
        return r;
    }

    public CTFProject getProjectByTitle(String title) throws RemoteException {
        for (CTFProject p : this.getProjects()) {
            if (!p.getTitle().equals(title)) continue;
            return p;
        }
        return null;
    }

    public CTFUser getMyself() throws RemoteException {
        return this.getUser(this.username);
    }

    public CTFUser getUser(String username) throws RemoteException {
        try {
            return new CTFUser(this, this.icns.getUserData(this.getSessionId(), username));
        }
        catch (NoSuchObjectFault e) {
            return null;
        }
        catch (AxisFault e) {
            if (NoSuchObjectFault.FAULT_CODE.equals(e.getFaultCode())) {
                return null;
            }
            throw e;
        }
    }

    public CTFUser createUser(String username, String email, String fullName, String locale, String timeZone, boolean isSuperUser, boolean isRestrictedUser, String password) throws RemoteException {
        String organization = null;
        String licenseType = "ALM";
        return new CTFUser(this, this.icns.createUser(this.getSessionId(), username, email, fullName, organization, locale, timeZone, licenseType, isSuperUser, isRestrictedUser, password));
    }

    public static CollabNetApp fromStapler(@QueryParameter boolean connectionFactory, @QueryParameter @RelativePath(value="connectionFactory") String url, @QueryParameter @RelativePath(value="connectionFactory") String username, @QueryParameter @RelativePath(value="connectionFactory") String password) {
        password = Secret.fromString((String)password).getPlainText();
        TeamForgeShare.TeamForgeShareDescriptor descriptor = TeamForgeShare.getTeamForgeShareDescriptor();
        if (descriptor != null && descriptor.useGlobal() && !connectionFactory) {
            url = descriptor.getCollabNetUrl();
            username = descriptor.getUsername();
            password = descriptor.getPassword();
        }
        if (CommonUtil.unset(url) || CommonUtil.unset(username) || CommonUtil.unset(password)) {
            return null;
        }
        return CNHudsonUtil.getCollabNetApp(url, username, password);
    }

    public static void disableSSLCertificateCheck() {
        TrustAllSocketFactory.install();
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        catch (KeyManagementException e) {
            throw new Error(e);
        }
    }

    public static class CollabNetAppException
    extends RuntimeException {
        public CollabNetAppException(String msg) {
            super(msg);
        }
    }
}

