/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class ValueResolver {
    Run<?, ?> run;
    FilePath workspace;
    TaskListener listener;
    PrintStream logger;

    public ValueResolver(Run<?, ?> run, FilePath workspace, TaskListener listener, PrintStream logger) {
        this.run = run;
        this.workspace = workspace;
        this.listener = listener;
        this.logger = logger;
    }

    public String resolve(String label, String value) throws IOException, InterruptedException {
        try {
            this.logger.println("Expanding '" + label + "' value: " + value + " (raw)");
            return TokenMacro.expandAll(this.run, (FilePath)this.workspace, (TaskListener)this.listener, (String)value);
        }
        catch (MacroEvaluationException e) {
            this.logger.println("Macro expansion for '" + label + "' failed, falling back to default behavior");
            e.printStackTrace(this.logger);
            return this.run.getEnvironment(this.listener).expand(value);
        }
    }
}

