/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.codedx.CodeDxDiff;
import org.jenkinsci.plugins.codedx.CodeDxDiffGroup;
import org.jenkinsci.plugins.codedx.model.CodeDxGroupStatistics;
import org.jenkinsci.plugins.codedx.model.CodeDxReportStatistics;

public class CodeDxDiffSummary
extends CodeDxDiff {
    private final List<CodeDxDiffGroup> groupDiffs;
    private String name;

    public CodeDxDiffSummary(List<CodeDxDiffGroup> groupDiffs, int findings, int findingsDelta, String name) {
        super(findings, findingsDelta);
        this.groupDiffs = groupDiffs;
        this.name = name;
    }

    public List<CodeDxDiffGroup> getGroupDiffs() {
        return this.groupDiffs;
    }

    public String getName() {
        return this.name;
    }

    public static CodeDxDiffSummary getDiffSummary(CodeDxReportStatistics previous, CodeDxReportStatistics current, String name, Comparator<CodeDxDiffGroup> comparator, Map<String, String> iconMap) {
        if (previous == null) {
            return CodeDxDiffSummary.getDiffSummary(current, name, comparator, iconMap);
        }
        HashSet<String> groups = new HashSet<String>();
        groups.addAll(previous.getAllGroups());
        groups.addAll(current.getAllGroups());
        ArrayList<CodeDxDiffGroup> result = new ArrayList<CodeDxDiffGroup>();
        int findings = 0;
        int findingsDelta = 0;
        for (String group : groups) {
            CodeDxGroupStatistics curStats = current.getGroup(group);
            CodeDxGroupStatistics prevStats = previous.getGroup(group);
            result.add(new CodeDxDiffGroup(curStats.getGroup(), curStats.getFindings(), curStats.getFindings() - prevStats.getFindings(), iconMap.get(curStats.getGroup())));
            findings += curStats.getFindings();
            findingsDelta += curStats.getFindings() - prevStats.getFindings();
        }
        Collections.sort(result, comparator);
        return new CodeDxDiffSummary(result, findings, findingsDelta, name);
    }

    private static CodeDxDiffSummary getDiffSummary(CodeDxReportStatistics current, String name, Comparator<CodeDxDiffGroup> comparator, Map<String, String> iconMap) {
        if (current == null) {
            return CodeDxDiffSummary.getDiffSummary(name);
        }
        ArrayList<CodeDxDiffGroup> result = new ArrayList<CodeDxDiffGroup>();
        int findings = 0;
        for (CodeDxGroupStatistics groupStats : current.getStatistics()) {
            result.add(new CodeDxDiffGroup(groupStats.getGroup(), groupStats.getFindings(), 0, iconMap.get(groupStats.getGroup())));
            findings += groupStats.getFindings();
        }
        Collections.sort(result, comparator);
        return new CodeDxDiffSummary(result, findings, 0, name);
    }

    private static CodeDxDiffSummary getDiffSummary(String name) {
        return new CodeDxDiffSummary(Collections.emptyList(), 0, 0, name);
    }
}

