/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.security;

import com.codedx.security.CertificateAcceptance;
import com.codedx.security.InvalidCertificateStrategy;
import com.codedx.util.HashUtil;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;

public class FingerprintStrategy
implements InvalidCertificateStrategy {
    private String fingerprint;
    private static final Logger logger = Logger.getLogger(FingerprintStrategy.class.getName());

    public FingerprintStrategy(String fingerprint) {
        this.fingerprint = fingerprint;
        if (fingerprint == null) {
            this.fingerprint = "";
        }
    }

    @Override
    public CertificateAcceptance checkAcceptance(Certificate genericCert, CertificateException certError) {
        if (genericCert instanceof X509Certificate) {
            X509Certificate cert = (X509Certificate)genericCert;
            try {
                String certFingerprint = HashUtil.toHexString(HashUtil.getSHA1(cert.getEncoded()));
                logger.info("Certificate fingerprint:  " + certFingerprint.toUpperCase());
                logger.info("User-entered fingerprint: " + this.fingerprint.toUpperCase());
                if (certFingerprint.toUpperCase().equals(this.fingerprint.toUpperCase())) {
                    return CertificateAcceptance.ACCEPT_PERMANENTLY;
                }
            }
            catch (CertificateEncodingException exception) {
                logger.warning("Problem reading certificate: " + exception);
                exception.printStackTrace();
            }
        } else {
            logger.warning("Certificate presented was not X509: " + genericCert);
        }
        return CertificateAcceptance.REJECT;
    }
}

