/*
 * Decompiled with CFR 0.152.
 */
package com.secdec.codedx.api.client;

import com.secdec.codedx.api.client.CodeDxClient;
import com.secdec.codedx.api.client.CodeDxClientException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.net.SocketException;
import org.apache.http.client.methods.HttpRequestBase;

public class CodeDxRepeatingClient
extends CodeDxClient {
    private PrintStream logger;

    public CodeDxRepeatingClient(CodeDxClient oldClient, PrintStream logger) {
        super(oldClient.url, oldClient.key, oldClient.httpClientBuilder);
        this.logger = logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> T doHttpRequest(HttpRequestBase request, String path, boolean isXApi, Type responseType, Object requestBody) throws IOException, CodeDxClientException {
        try {
            int fails = 0;
            block17: while (fails < 3) {
                try {
                    try {
                        HttpRequestBase clonedRequest = (HttpRequestBase)request.clone();
                        return super.doHttpRequest(clonedRequest, path, isXApi, responseType, requestBody);
                    }
                    catch (CloneNotSupportedException e) {
                        throw new IOException("Could not clone request body entity: " + requestBody);
                    }
                }
                catch (CodeDxClientException clientException) {
                    this.logger.println("Attempt " + ++fails + " " + clientException.getMessage() + " response code: " + clientException.getHttpCode());
                    switch (fails) {
                        case 1: {
                            this.logger.println("Trying again after 1 second");
                            Thread.sleep(1000L);
                            continue block17;
                        }
                        case 2: {
                            this.logger.println("Trying again after 5 seconds");
                            Thread.sleep(5000L);
                            continue block17;
                        }
                        case 3: {
                            this.logger.println("Trying again after 30 seconds");
                            Thread.sleep(30000L);
                            continue block17;
                        }
                    }
                    throw clientException;
                }
                catch (SocketException socketException) {
                    this.logger.println("Attempt " + ++fails + " " + socketException.getMessage());
                    switch (fails) {
                        case 1: {
                            this.logger.println("Trying again after 1 second");
                            Thread.sleep(1000L);
                            continue block17;
                        }
                        case 2: {
                            this.logger.println("Trying again after 5 seconds");
                            Thread.sleep(5000L);
                            continue block17;
                        }
                        case 3: {
                            this.logger.println("Trying again after 30 seconds");
                            Thread.sleep(30000L);
                            continue block17;
                        }
                    }
                    throw socketException;
                    throw new CodeDxClientException("GET", path, "GET was unsuccessful for " + path, -1, "");
                }
            }
        }
        catch (InterruptedException i) {
            this.logger.println("Thread was interrupted while waiting to re-attempt GET");
            throw new CodeDxClientException("GET", path, "Thread was interrupted. Unabled to finish GET", -1, "");
        }
    }
}

