/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;

public class DeferredFilePathInputStream
extends InputStream {
    FilePath fp;
    InputStream is;

    public DeferredFilePathInputStream(FilePath fp) {
        this.fp = fp;
        this.is = null;
    }

    private void initStream() throws IOException {
        if (this.is == null) {
            try {
                this.is = this.fp.read();
            }
            catch (InterruptedException e) {
                throw new IOException("Operation was interrupted", e);
            }
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.initStream();
        int numRead = this.is.read(b);
        if (numRead < b.length) {
            this.is.close();
        }
        return numRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.initStream();
        int numRead = this.is.read(b, off, len);
        if (numRead < len) {
            this.is.close();
        }
        return numRead;
    }

    @Override
    public int read() throws IOException {
        this.initStream();
        int result = this.is.read();
        if (result < 0) {
            this.is.close();
        }
        return result;
    }
}

