/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.model.Action;
import hudson.model.Run;
import hudson.util.Graph;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import org.jenkinsci.plugins.codedx.AnalysisResultConfiguration;
import org.jenkinsci.plugins.codedx.CodeDxBuildAction;
import org.jenkinsci.plugins.codedx.CodeDxChartBuilder;
import org.jenkinsci.plugins.codedx.CodeDxResult;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CodeDxProjectAction
implements Action {
    public static final String URL_NAME = "codedxResult";
    public static final int CHART_WIDTH = 500;
    public static final int CHART_HEIGHT = 200;
    private final Run<?, ?> run;
    private final String latestAnalysisUrl;
    private AnalysisResultConfiguration analysisResultConfiguration;

    public CodeDxProjectAction(Run<?, ?> run, AnalysisResultConfiguration analysisResultConfiguration, String latestAnalysisUrl) {
        this.run = run;
        this.analysisResultConfiguration = analysisResultConfiguration;
        this.latestAnalysisUrl = latestAnalysisUrl;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getLatestAnalysisUrl() {
        return this.latestAnalysisUrl;
    }

    public AnalysisResultConfiguration getAnalysisResultConfiguration() {
        return this.analysisResultConfiguration;
    }

    public boolean showTablesAndCharts() {
        return this.analysisResultConfiguration != null;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        Run<?, ?> build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), URL_NAME));
        } else {
            response.sendRedirect2("..");
        }
    }

    public Run<?, ?> getLastFinishedBuild() {
        Run lastBuild;
        for (lastBuild = this.run; lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(CodeDxBuildAction.class) == null); lastBuild = lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public CodeDxBuildAction getLastFinishedBuildAction() {
        Run<?, ?> lastBuild = this.getLastFinishedBuild();
        return lastBuild != null ? (CodeDxBuildAction)lastBuild.getAction(CodeDxBuildAction.class) : null;
    }

    public final boolean hasValidResults() {
        Run<?, ?> build = this.getLastFinishedBuild();
        if (build != null) {
            int nbr_results = 0;
            for (CodeDxBuildAction resultAction = (CodeDxBuildAction)build.getAction(CodeDxBuildAction.class); resultAction != null; resultAction = resultAction.getPreviousAction()) {
                CodeDxResult result = resultAction.getResult();
                if (result == null || ++nbr_results <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public void doSeverityTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        Run<?, ?> lastBuild = this.getLastFinishedBuild();
        final CodeDxBuildAction lastAction = (CodeDxBuildAction)lastBuild.getAction(CodeDxBuildAction.class);
        final HashMap<String, Color> colorMap = new HashMap<String, Color>();
        colorMap.put("Critical", new Color(8787838));
        colorMap.put("High", new Color(12386342));
        colorMap.put("Medium", new Color(16616764));
        colorMap.put("Low", new Color(16701814));
        colorMap.put("Info", new Color(0x888888));
        colorMap.put("Unspecified", new Color(0xADADAD));
        new Graph(-1L, 500, 200){

            protected JFreeChart createGraph() {
                return CodeDxChartBuilder.buildChart(lastAction, CodeDxProjectAction.this.analysisResultConfiguration.getNumBuildsInGraph(), "severity", colorMap);
            }
        }.doPng(request, response);
    }

    public void doStatusTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        Run<?, ?> lastBuild = this.getLastFinishedBuild();
        final CodeDxBuildAction lastAction = (CodeDxBuildAction)lastBuild.getAction(CodeDxBuildAction.class);
        final HashMap<String, Color> colorMap = new HashMap<String, Color>();
        colorMap.put("New", new Color(5515144));
        colorMap.put("Unresolved", new Color(10063555));
        colorMap.put("Reopened", new Color(11296167));
        colorMap.put("Fixed", new Color(3311805));
        colorMap.put("Mitigated", new Color(2711238));
        colorMap.put("Assigned", new Color(91742));
        colorMap.put("Escalated", new Color(5944492));
        colorMap.put("Ignored", new Color(14201701));
        colorMap.put("False Positive", new Color(0xD9D9D9));
        new Graph(-1L, 500, 200){

            protected JFreeChart createGraph() {
                return CodeDxChartBuilder.buildChart(lastAction, CodeDxProjectAction.this.analysisResultConfiguration.getNumBuildsInGraph(), "status", colorMap);
            }
        }.doPng(request, response);
    }
}

