/*
 * Decompiled with CFR 0.152.
 */
package com.secdec.codedx.api.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.secdec.codedx.api.client.CodeDxClientException;
import com.secdec.codedx.api.client.CountGroup;
import com.secdec.codedx.api.client.CountRequest;
import com.secdec.codedx.api.client.CountResponse;
import com.secdec.codedx.api.client.Filter;
import com.secdec.codedx.api.client.GetProjectsResponse;
import com.secdec.codedx.api.client.GroupedCountRequest;
import com.secdec.codedx.api.client.Job;
import com.secdec.codedx.api.client.Project;
import com.secdec.codedx.api.client.StartAnalysisResponse;
import com.secdec.codedx.api.client.TriageStatus;
import com.secdec.codedx.util.CodeDxVersion;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class CodeDxClient {
    private final String KEY_HEADER = "API-Key";
    protected String key;
    protected String url;
    private String serverUrl;
    protected HttpClientBuilder httpClientBuilder;
    private Gson gson;

    public CodeDxClient(String url, String key) {
        this(url, key, HttpClientBuilder.create());
    }

    public CodeDxClient(String url, String key, HttpClientBuilder clientBuilder) {
        this.key = key;
        if (url == null) {
            throw new NullPointerException("Argument url is null");
        }
        if (key == null) {
            throw new NullPointerException("Argument key is null");
        }
        if (!(url = url.trim()).endsWith("/")) {
            url = url + "/";
        }
        if (!url.endsWith("api/")) {
            url = url + "api/";
        }
        this.url = url;
        this.serverUrl = url.replace("/api/", "/");
        this.httpClientBuilder = clientBuilder;
        this.gson = new Gson();
    }

    @Deprecated
    public String buildBrowsableAnalysisRunUrl(int projectId) {
        return this.serverUrl + "projects/" + projectId;
    }

    public String buildLatestFindingsUrl(int projectId) {
        return this.serverUrl + "projects/" + projectId;
    }

    public List<Project> getProjects() throws CodeDxClientException, IOException {
        GetProjectsResponse response = (GetProjectsResponse)this.doHttpRequest((HttpRequestBase)new HttpGet(), "projects", false, new TypeToken<GetProjectsResponse>(){}.getType(), null);
        return response.getProjects();
    }

    public Project getProject(int id) throws CodeDxClientException, IOException {
        return (Project)this.doHttpRequest((HttpRequestBase)new HttpGet(), "projects/" + id, true, new TypeToken<Project>(){}.getType(), null);
    }

    public Map<String, TriageStatus> getTriageStatuses(int id) throws CodeDxClientException, IOException {
        return (Map)this.doHttpRequest((HttpRequestBase)new HttpGet(), "projects/" + id + "/statuses", true, new TypeToken<Map<String, TriageStatus>>(){}.getType(), null);
    }

    public Job getJob(String id) throws CodeDxClientException, IOException {
        return (Job)this.doHttpRequest((HttpRequestBase)new HttpGet(), "jobs/" + id, false, new TypeToken<Job>(){}.getType(), null);
    }

    public String getJobStatus(String id) throws CodeDxClientException, IOException {
        return this.getJob(id).getStatus();
    }

    public int getFindingsCount(String id) throws CodeDxClientException, IOException {
        CountResponse resp = (CountResponse)this.doHttpRequest((HttpRequestBase)new HttpGet(), "runs/" + id + "/findings/count", true, new TypeToken<CountResponse>(){}.getType(), null);
        return resp.getCount();
    }

    public int getFindingsCount(int projectId, Filter filter) throws CodeDxClientException, IOException {
        CountResponse resp = (CountResponse)this.doHttpRequest((HttpRequestBase)new HttpPost(), "projects/" + projectId + "/findings/count", true, new TypeToken<CountResponse>(){}.getType(), new CountRequest(filter));
        return resp.getCount();
    }

    public List<CountGroup> getFindingsGroupedCounts(int projectId, Filter filter, String countBy) throws CodeDxClientException, IOException {
        return (List)this.doHttpRequest((HttpRequestBase)new HttpPost(), "projects/" + projectId + "/findings/grouped-counts", true, new TypeToken<List<CountGroup>>(){}.getType(), new GroupedCountRequest(filter, countBy));
    }

    public void setAnalysisName(int projectId, int analysisId, String name) throws IOException, CodeDxClientException {
        JsonObject reqBody = new JsonObject();
        reqBody.addProperty("name", name);
        this.doHttpRequest((HttpRequestBase)new HttpPut(), "projects/" + projectId + "/analyses/" + analysisId, true, null, reqBody);
    }

    public CodeDxVersion getCodeDxVersion() throws IOException, CodeDxClientException {
        CodeDxVersionResponse resp = (CodeDxVersionResponse)this.doHttpRequest((HttpRequestBase)new HttpGet(), "system-info", true, new TypeToken<CodeDxVersionResponse>(){}.getType(), null);
        return CodeDxVersion.fromString(resp.version);
    }

    protected <T> T doHttpRequest(HttpRequestBase request, String path, boolean isXApi, Type responseType, Object requestBody) throws IOException, CodeDxClientException {
        String apiPath = (isXApi ? this.url.replace("/api/", "/x/") : this.url) + path;
        request.setURI(URI.create(apiPath));
        request.addHeader("API-Key", this.key);
        if (requestBody != null && request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)request;
            StringEntity requestBodyEntity = new StringEntity(this.gson.toJson(requestBody));
            entityRequest.setEntity((HttpEntity)requestBodyEntity);
        }
        Throwable throwable = null;
        try (CloseableHttpClient client = this.httpClientBuilder.build();){
            String responseBody;
            int responseCode;
            Throwable throwable2;
            CloseableHttpResponse response;
            block33: {
                block34: {
                    T t;
                    block35: {
                        block36: {
                            response = client.execute((HttpUriRequest)request);
                            throwable2 = null;
                            responseCode = response.getStatusLine().getStatusCode();
                            boolean isSuccess = responseCode / 100 == 2;
                            String string = responseBody = response.getEntity() == null ? null : IOUtils.toString((InputStream)response.getEntity().getContent());
                            if (!isSuccess) break block33;
                            if (responseType != null && responseBody != null) break block34;
                            t = null;
                            if (response == null) break block35;
                            if (throwable2 == null) break block36;
                            try {
                                response.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            break block35;
                        }
                        response.close();
                    }
                    return t;
                }
                Object object = this.gson.fromJson(responseBody, responseType);
                return (T)object;
            }
            try {
                try {
                    throw new CodeDxClientException(request.getMethod(), apiPath, response.getStatusLine().getReasonPhrase(), responseCode, responseBody);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (response != null) {
                    if (throwable2 != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
    }

    public StartAnalysisResponse startAnalysis(int projectId, Map<String, InputStream> artifacts) throws IOException, CodeDxClientException {
        String path = "projects/" + projectId + "/analysis";
        HttpPost postRequest = new HttpPost(this.url + path);
        postRequest.addHeader("API-Key", this.key);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (String artifactName : artifacts.keySet()) {
            builder.addPart("file[]", (ContentBody)new InputStreamBody(artifacts.get(artifactName), artifactName));
        }
        HttpEntity entity = builder.build();
        postRequest.setEntity(entity);
        CloseableHttpResponse response = this.httpClientBuilder.build().execute((HttpUriRequest)postRequest);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 202) {
            throw new CodeDxClientException("POST", path, response.getStatusLine().getReasonPhrase(), responseCode, IOUtils.toString((InputStream)response.getEntity().getContent()));
        }
        String data = IOUtils.toString((InputStream)response.getEntity().getContent());
        return (StartAnalysisResponse)this.gson.fromJson(data, new TypeToken<StartAnalysisResponse>(){}.getType());
    }

    private class CodeDxVersionResponse {
        public String version;
        public String date;

        private CodeDxVersionResponse() {
        }
    }
}

