/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx.model;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.jenkinsci.plugins.codedx.model.CodeDxGroupStatistics;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeDxReportStatistics
implements Serializable {
    private static final long serialVersionUID = 0L;
    private List<CodeDxGroupStatistics> statistics;

    public CodeDxReportStatistics(List<CodeDxGroupStatistics> statistics) {
        System.out.println("Statistics is: " + statistics);
        this.statistics = statistics;
    }

    @Exported(name="groups")
    public List<CodeDxGroupStatistics> getStatistics() {
        return this.statistics;
    }

    @Exported(name="totalFindings")
    public int getFindings() {
        int findings = 0;
        for (CodeDxGroupStatistics it : this.statistics) {
            findings += it.getFindings();
        }
        return findings;
    }

    public List<String> getAllGroups() {
        LinkedList<String> groups = new LinkedList<String>();
        for (CodeDxGroupStatistics it : this.statistics) {
            groups.add(it.getGroup());
        }
        return groups;
    }

    public CodeDxGroupStatistics getGroup(String group) {
        for (CodeDxGroupStatistics it : this.statistics) {
            if (!it.getGroup().equals(group)) continue;
            return it;
        }
        return new CodeDxGroupStatistics(group, 0);
    }
}

