/*
 * Decompiled with CFR 0.152.
 */
package com.secdec.codedx.security;

import com.secdec.codedx.security.CompositeX509TrustManager;
import com.secdec.codedx.security.FingerprintStrategy;
import com.secdec.codedx.security.ReloadableX509TrustManager;
import com.secdec.codedx.security.SingleCertManager;
import com.secdec.codedx.security.X509HostnameVerifierWithExceptions;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.LinkedList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class JenkinsSSLConnectionSocketFactoryFactory {
    public static SSLConnectionSocketFactory getFactory(String fingerprint, String host) throws GeneralSecurityException {
        SingleCertManager certManager = new SingleCertManager("floopydoop");
        X509HostnameVerifier defaultHostnameVerifier = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
        FingerprintStrategy certificateStrategy = new FingerprintStrategy(fingerprint);
        LinkedList<X509TrustManager> trustManagersForComposite = new LinkedList<X509TrustManager>();
        X509TrustManager systemTrustManager = JenkinsSSLConnectionSocketFactoryFactory.getDefaultTrustManager();
        ReloadableX509TrustManager customTrustManager = new ReloadableX509TrustManager(certManager, certificateStrategy);
        trustManagersForComposite.add(systemTrustManager);
        trustManagersForComposite.add(customTrustManager);
        CompositeX509TrustManager trustManager = new CompositeX509TrustManager(trustManagersForComposite);
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        HashSet<String> allowedHosts = new HashSet<String>();
        allowedHosts.add(host);
        X509HostnameVerifierWithExceptions modifiedHostnameVerifier = new X509HostnameVerifierWithExceptions(defaultHostnameVerifier, allowedHosts);
        return new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)modifiedHostnameVerifier);
    }

    private static X509TrustManager getDefaultTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] managers;
        TrustManagerFactory defaultFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        defaultFactory.init((KeyStore)null);
        for (TrustManager mgr : managers = defaultFactory.getTrustManagers()) {
            if (!(mgr instanceof X509TrustManager)) continue;
            return (X509TrustManager)mgr;
        }
        return null;
    }
}

