/*
 * Decompiled with CFR 0.152.
 */
package com.secdec.codedx.api.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.secdec.codedx.api.client.CodeDxClientException;
import com.secdec.codedx.api.client.GetProjectsResponse;
import com.secdec.codedx.api.client.Project;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeDxClient {
    private final String KEY_HEADER = "API-Key";
    private String key;
    private String url;
    private DefaultHttpClient httpClient;
    private Gson gson;

    public CodeDxClient(String url, String key) {
        this.key = key;
        if (url == null) {
            throw new NullPointerException("Argument url is null");
        }
        if (key == null) {
            throw new NullPointerException("Argument key is null");
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (!url.endsWith("api/")) {
            url = url + "api/";
        }
        this.url = url;
        this.httpClient = new DefaultHttpClient();
        this.gson = new Gson();
    }

    public List<Project> getProjects() throws CodeDxClientException, ClientProtocolException, IOException {
        GetProjectsResponse response = (GetProjectsResponse)this.doGet("projects", new TypeToken<GetProjectsResponse>(){}.getType());
        return response.getProjects();
    }

    public Project getProject(int id) throws CodeDxClientException, ClientProtocolException, IOException {
        return (Project)this.doGet("projects/id", new TypeToken<Project>(){}.getType());
    }

    private <T> T doGet(String path, Type typeOfT) throws ClientProtocolException, IOException, CodeDxClientException {
        HttpGet getRequest = new HttpGet(this.url + path);
        getRequest.addHeader("API-Key", this.key);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)getRequest);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 200) {
            throw new CodeDxClientException("failed to get from: " + path, responseCode);
        }
        String data = IOUtils.toString((InputStream)response.getEntity().getContent());
        return (T)this.gson.fromJson(data, typeOfT);
    }

    public void startAnalysis(int projectId, InputStream[] artifacts) throws ClientProtocolException, IOException, CodeDxClientException {
        HttpPost postRequest = new HttpPost(this.url + "projects/" + projectId + "/analysis");
        postRequest.addHeader("API-Key", this.key);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (InputStream artifact : artifacts) {
            builder.addPart("file[]", (ContentBody)new InputStreamBody(artifact, "file[]"));
        }
        HttpEntity entity = builder.build();
        postRequest.setEntity(entity);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 202) {
            throw new CodeDxClientException("Failed to start analysis.  " + IOUtils.toString((InputStream)response.getEntity().getContent()), responseCode);
        }
    }
}

