/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.cloudfoundryjenkins;

import com.hpe.cloudfoundryjenkins.AbstractCloudFoundryPushDescriptor;
import com.hpe.cloudfoundryjenkins.CloudFoundryPushPublisher;
import com.hpe.cloudfoundryjenkins.CloudFoundryPushTask;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CloudFoundryPushBuilder
extends Builder
implements SimpleBuildStep {
    public String target;
    public String organization;
    public String cloudSpace;
    public String credentialsId;
    public String selfSigned = "false";
    public String pluginTimeout = String.valueOf(120);
    public List<CloudFoundryPushPublisher.Service> servicesToCreate = new ArrayList<CloudFoundryPushPublisher.Service>();
    public CloudFoundryPushPublisher.ManifestChoice manifestChoice = CloudFoundryPushPublisher.ManifestChoice.defaultManifestFileConfig();

    @DataBoundConstructor
    public CloudFoundryPushBuilder(String target, String organization, String cloudSpace, String credentialsId) {
        this.target = target;
        this.organization = organization;
        this.cloudSpace = cloudSpace;
        this.credentialsId = credentialsId;
    }

    public String isSelfSigned() {
        return this.selfSigned;
    }

    @DataBoundSetter
    public void setSelfSigned(String selfSigned) {
        this.selfSigned = selfSigned;
    }

    public String getPluginTimeout() {
        return this.pluginTimeout;
    }

    @DataBoundSetter
    public void setPluginTimeout(String pluginTimeout) {
        if (pluginTimeout == null) {
            this.pluginTimeout = String.valueOf(120);
        } else {
            try {
                int i = Integer.parseInt(pluginTimeout);
                this.pluginTimeout = i <= 0 ? String.valueOf(120) : pluginTimeout;
            }
            catch (NumberFormatException ignored) {
                this.pluginTimeout = pluginTimeout;
            }
        }
    }

    public List<CloudFoundryPushPublisher.Service> getServicesToCreate() {
        return this.servicesToCreate;
    }

    @DataBoundSetter
    public void setServicesToCreate(List<CloudFoundryPushPublisher.Service> servicesToCreate) {
        this.servicesToCreate = servicesToCreate == null ? new ArrayList<CloudFoundryPushPublisher.Service>() : servicesToCreate;
    }

    public CloudFoundryPushPublisher.ManifestChoice getManifestChoice() {
        return this.manifestChoice;
    }

    @DataBoundSetter
    public void setManifestChoice(CloudFoundryPushPublisher.ManifestChoice manifestChoice) {
        this.manifestChoice = manifestChoice == null ? CloudFoundryPushPublisher.ManifestChoice.defaultManifestFileConfig() : manifestChoice;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        CloudFoundryPushTask task = new CloudFoundryPushTask(this.target, this.organization, this.cloudSpace, this.credentialsId, this.selfSigned, this.pluginTimeout, this.servicesToCreate, this.manifestChoice);
        return task.perform(build.getWorkspace(), (Run)build, launcher, (TaskListener)listener);
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        CloudFoundryPushTask task = new CloudFoundryPushTask(this.target, this.organization, this.cloudSpace, this.credentialsId, this.selfSigned, this.pluginTimeout, this.servicesToCreate, this.manifestChoice);
        if (!task.perform(workspace, run, launcher, listener)) {
            throw new AbortException("CloudFoundry Push failed.");
        }
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.emptySet();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Symbol(value={"pushToCloudFoundry", "cfPush"})
    @Extension
    public static final class DescriptorImpl
    extends AbstractCloudFoundryPushDescriptor<Builder> {
    }
}

