/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.advisor;

import com.cloudbees.jenkins.plugins.advisor.AdvisorGlobalConfiguration;
import com.cloudbees.jenkins.plugins.advisor.client.AdvisorClient;
import com.cloudbees.jenkins.plugins.advisor.client.PluginHelper;
import com.cloudbees.jenkins.plugins.advisor.client.model.ClientResponse;
import com.cloudbees.jenkins.plugins.advisor.client.model.ClientUploadRequest;
import com.cloudbees.jenkins.plugins.advisor.client.model.Recipient;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import java.io.File;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"bundleUpload"})
public class BundleUpload
extends AsyncPeriodicWork {
    public static final int RECURRENCE_PERIOD_HOURS = Integer.getInteger(BundleUpload.class.getName() + ".recurrencePeriodHours", 24);
    public static final int INITIAL_DELAY_MINUTES = Integer.getInteger(BundleUpload.class.getName() + ".initialDelayMinutes", 30);
    private static final Logger LOG = Logger.getLogger(BundleUpload.class.getName());
    private static final String UNABLE_TO_GENERATE_SUPPORT_BUNDLE = "Unable to generate support bundle";
    private static final String COULD_NOT_SAVE_SUPPORT_BUNDLE = "Unable to save support bundle";
    private static final String BUNDLE_DIR_DOES_NOT_EXIST = "Bundle root directory does not exist and could not be created";
    protected static final String BUNDLE_SUCCESSFULLY_UPLOADED = "Bundle uploaded";
    private TaskListener task;

    public BundleUpload() {
        super("Bundle Upload");
    }

    protected void execute(TaskListener listener) {
        this.task = listener;
        AdvisorGlobalConfiguration config = AdvisorGlobalConfiguration.getInstance();
        if (config == null) {
            return;
        }
        if (!config.isPluginEnabled()) {
            this.log(Level.INFO, "Jenkins Health Advisor by CloudBees plugin disabled. Skipping bundle upload.");
            this.updateLastBundleResult(config, this.createTimestampedWarnMessage("<strong>Plugin disabled</strong>, the upload was skipped"));
            return;
        }
        if (!config.isValid()) {
            this.log(Level.INFO, "Invalid configuration. Skipping bundle upload.");
            this.updateLastBundleResult(config, this.createTimestampedWarnMessage("<strong>Invalid configuration</strong>, the upload was skipped"));
            return;
        }
        File bundle = this.generateBundle();
        String pluginVersion = PluginHelper.getPluginVersion();
        if (bundle != null) {
            this.executeInternal(config.getEmail(), bundle, pluginVersion);
        } else {
            this.log(Level.SEVERE, UNABLE_TO_GENERATE_SUPPORT_BUNDLE);
        }
    }

    /*
     * Exception decompiling
     */
    private File generateBundle() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeInternal(String email, File file, String pluginVersion) {
        AdvisorGlobalConfiguration config = AdvisorGlobalConfiguration.getInstance();
        try {
            AdvisorClient advisorClient = new AdvisorClient(new Recipient(email));
            ClientResponse response = advisorClient.uploadFile(new ClientUploadRequest(Jenkins.get().getLegacyInstanceId(), file, config.getCcs(), pluginVersion));
            if (response.getCode() == 200) {
                this.updateLastBundleResult(config, this.createTimestampedInfoMessage(BUNDLE_SUCCESSFULLY_UPLOADED));
            } else {
                this.updateLastBundleResult(config, this.createTimestampedErrorMessage("<strong>Bundle upload failed</strong><br/>Server response is: <code>%d - %s</code>", response.getCode(), response.getMessage()));
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Issue while uploading file to bundle upload service: " + e.getMessage());
            this.log(Level.FINEST, "Exception while uploading file to bundle upload service. Cause: " + ExceptionUtils.getStackTrace((Throwable)e));
            this.updateLastBundleResult(config, this.createTimestampedErrorMessage("<strong>Bundle upload failed</strong><br/><pre><code>%s</code></pre>", e.getMessage()));
        }
    }

    public long getRecurrencePeriod() {
        return TimeUnit.HOURS.toMillis(RECURRENCE_PERIOD_HOURS);
    }

    private void log(Level level, String message) {
        if (this.task != null) {
            if (level.equals(Level.SEVERE) || level.equals(Level.WARNING)) {
                this.task.error(message);
            } else {
                this.task.getLogger().println(message);
            }
        }
        LOG.log(level, message);
    }

    private void logError(String message, Throwable t) {
        if (this.task != null) {
            this.task.error(message, new Object[]{t});
        }
        LOG.log(Level.SEVERE, message, t);
    }

    private String createTimestampedInfoMessage(String message) {
        return this.createTimestampedMessage(null, message);
    }

    private String createTimestampedWarnMessage(String message) {
        return this.createTimestampedMessage("WARNING", message);
    }

    private String createTimestampedErrorMessage(String format, Object ... args) {
        return this.createTimestampedMessage("ERROR", format, args);
    }

    private String createTimestampedMessage(String level, String format, Object ... args) {
        return this.createTimestampedMessage(level, String.format(format, args));
    }

    private String createTimestampedMessage(String level, String message) {
        if (level != null) {
            return String.format("%1$s - %2$tF %2$tT - %3$s", level, Calendar.getInstance().getTime(), message);
        }
        return String.format("%1$tF %1$tT - %2$s", Calendar.getInstance().getTime(), message);
    }

    private void updateLastBundleResult(AdvisorGlobalConfiguration config, String message) {
        config.setLastBundleResult(message);
        config.save();
    }

    public long getInitialDelay() {
        return TimeUnit.MINUTES.toMillis(INITIAL_DELAY_MINUTES);
    }
}

