/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class EventOutputStreams
implements Closeable {
    private final BlockingQueue<byte[]> pending = new LinkedBlockingQueue<byte[]>();
    private final AtomicInteger pendingSize = new AtomicInteger();
    private final OutputFile outputFile;
    private final long flushIntervalNanos;
    private final int flushSize;
    private final long rotateSize;
    private final int fileCount;
    private boolean appendNextOpen;
    private volatile long lastFlushNanos;
    private final Object writeLock = new Object();

    public EventOutputStreams(OutputFile outputFile, boolean append) {
        this(outputFile, append, 0);
    }

    public EventOutputStreams(OutputFile outputFile, boolean append, int fileCount) {
        this(outputFile, 250L, TimeUnit.MILLISECONDS, 1024, append, 32768L, fileCount);
    }

    public EventOutputStreams(OutputFile outputFile, long flushInterval, TimeUnit flushIntervalUnits, int flushSize, boolean append, long rotateSize, int fileCount) {
        this.outputFile = outputFile;
        this.flushIntervalNanos = flushIntervalUnits.toNanos(flushInterval);
        this.flushSize = flushSize;
        this.fileCount = fileCount;
        this.rotateSize = rotateSize;
        this.appendNextOpen = append;
        this.lastFlushNanos = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void offer(byte[] content) throws IOException {
        int pendingSize;
        if (content == null) {
            pendingSize = this.pendingSize.get();
        } else {
            if (!this.pending.offer(content)) {
                throw new IOException("buffer full");
            }
            pendingSize = this.pendingSize.addAndGet(content.length);
        }
        if (content == null || pendingSize >= this.flushSize || System.nanoTime() - this.lastFlushNanos > this.flushIntervalNanos) {
            Object object = this.writeLock;
            synchronized (object) {
                if (!this.outputFile.canWriteNow()) {
                    return;
                }
                File file = this.outputFile.get();
                if (!this.appendNextOpen || file.length() > this.rotateSize) {
                    if (this.fileCount > 0) {
                        for (int i = this.fileCount - 1; i >= 0; --i) {
                            File f;
                            File file2 = f = i == 0 ? file : new File(file.getParent(), file.getName() + "." + i);
                            if (!f.exists()) continue;
                            File n = new File(file.getParent(), file.getName() + "." + (i + 1));
                            n.delete();
                            f.renameTo(n);
                        }
                    } else {
                        this.appendNextOpen = false;
                    }
                }
                FileOutputStream os = null;
                try {
                    byte[] bytes;
                    os = new FileOutputStream(file, this.appendNextOpen);
                    while (null != (bytes = (byte[])this.pending.poll())) {
                        this.pendingSize.addAndGet(-bytes.length);
                        os.write(bytes);
                    }
                    os.flush();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.appendNextOpen = true;
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public OutputStream get() {
        return new OutputStream(){
            private final byte[] buf = new byte[1024];
            private int index = 0;
            private long start = System.nanoTime();

            @Override
            public void write(int b) throws IOException {
                this.buf[this.index] = (byte)b;
                ++this.index;
                this.lazyFlush();
            }

            private void lazyFlush() throws IOException {
                long end = System.nanoTime();
                if (this.index >= this.buf.length || end - this.start > EventOutputStreams.this.flushIntervalNanos) {
                    this.start = end;
                    if (this.index == 0) {
                        return;
                    }
                    int count = this.index;
                    for (int i = this.index - 1; i >= 0; --i) {
                        if (this.buf[i] != 10) continue;
                        count = i + 1;
                        break;
                    }
                    if (this.index == count) {
                        EventOutputStreams.this.offer(Arrays.copyOf(this.buf, count));
                        this.index = 0;
                    } else {
                        EventOutputStreams.this.offer(Arrays.copyOf(this.buf, count));
                        System.arraycopy(this.buf, count, this.buf, 0, this.index - count);
                        this.index -= count;
                    }
                }
            }

            @Override
            public void write(byte[] data, int off, int len) throws IOException {
                if (data == null) {
                    throw new NullPointerException();
                }
                if (this.index + len <= this.buf.length) {
                    System.arraycopy(data, off, this.buf, this.index, len);
                    this.index += len;
                    this.lazyFlush();
                } else {
                    while (len > 0) {
                        int l = Math.min(len, this.buf.length - this.index);
                        if (l > 0) {
                            System.arraycopy(data, off, this.buf, this.index, l);
                            this.index += l;
                            off += l;
                            len -= l;
                        }
                        this.lazyFlush();
                    }
                }
            }

            @Override
            public void flush() throws IOException {
                this.start = System.nanoTime();
                if (this.index > 0) {
                    EventOutputStreams.this.offer(Arrays.copyOf(this.buf, this.index));
                    this.index = 0;
                }
            }

            @Override
            public void close() throws IOException {
                this.flush();
                EventOutputStreams.this.offer(null);
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.offer(null);
    }

    public static abstract class OutputFile {
        @NonNull
        public abstract File get();

        public boolean canWriteNow() {
            return true;
        }
    }
}

