/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import com.cloudbees.hudson.plugins.folder.ChildNameGenerator;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import com.cloudbees.hudson.plugins.folder.Messages;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.util.FormValidation;
import hudson.views.ViewsTabBar;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AbstractFolderDescriptor
extends TopLevelItemDescriptor
implements IconSpec {
    protected AbstractFolderDescriptor(Class<? extends AbstractFolder> clazz) {
        super(clazz);
    }

    protected AbstractFolderDescriptor() {
    }

    public String getDisplayName() {
        return Messages.Folder_DisplayName();
    }

    public String getCategoryId() {
        return "nested-projects";
    }

    public List<AbstractFolderPropertyDescriptor> getPropertyDescriptors() {
        return AbstractFolderPropertyDescriptor.getApplicableDescriptors(this.clazz.asSubclass(AbstractFolder.class));
    }

    public List<FolderHealthMetricDescriptor> getHealthMetricDescriptors() {
        ArrayList<FolderHealthMetricDescriptor> r = new ArrayList<FolderHealthMetricDescriptor>();
        for (FolderHealthMetricDescriptor d : FolderHealthMetricDescriptor.all()) {
            if (!d.isApplicable(this.clazz.asSubclass(AbstractFolder.class))) continue;
            r.add(d);
        }
        return r;
    }

    public List<FolderIconDescriptor> getIconDescriptors() {
        AbstractFolder folder;
        ArrayList<FolderIconDescriptor> r = new ArrayList<FolderIconDescriptor>();
        for (FolderIconDescriptor p : FolderIconDescriptor.all()) {
            if (!p.isApplicable(this.clazz.asSubclass(AbstractFolder.class))) continue;
            r.add(p);
        }
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null && (folder = (AbstractFolder)((Object)request.findAncestorObject(AbstractFolder.class))) != null) {
            return DescriptorVisibilityFilter.apply((Object)((Object)folder), r);
        }
        return r;
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation doCheckDisplayNameOrNull(@AncestorInPath AbstractFolder folder, @QueryParameter String value) {
        return Jenkins.get().doCheckDisplayName(value, folder.getName());
    }

    public String getIconFilePathPattern() {
        return "plugin/cloudbees-folder/images/svgs/folder.svg";
    }

    public String getIconClassName() {
        return "symbol-folder-outline plugin-ionicons-api";
    }

    public boolean isIconConfigurable() {
        return this.getIconDescriptors().size() > 1;
    }

    public boolean isTabBarConfigurable() {
        return Jenkins.get().getDescriptorList(ViewsTabBar.class).size() > 1;
    }

    public boolean isLookAndFeelConfigurable(AbstractFolder<?> folder) {
        return this.isIconConfigurable() || this.isTabBarConfigurable() && folder.getFolderViews().isTabBarModifiable() || folder.getViews().size() > 1 && folder.getFolderViews().isPrimaryModifiable();
    }

    @NonNull
    public <I extends TopLevelItem> ChildNameGenerator<AbstractFolder<I>, I> childNameGenerator() {
        return new LegacyChildNameGenerator();
    }

    private static class LegacyChildNameGenerator<I extends TopLevelItem>
    extends ChildNameGenerator<AbstractFolder<I>, I> {
        private LegacyChildNameGenerator() {
        }

        @Override
        public String itemNameFromItem(@NonNull AbstractFolder<I> parent, @NonNull I item) {
            return item.getName();
        }

        @Override
        public String dirNameFromItem(@NonNull AbstractFolder<I> parent, @NonNull I item) {
            return item.getName();
        }

        @Override
        @NonNull
        public String itemNameFromLegacy(@NonNull AbstractFolder<I> parent, @NonNull String legacyDirName) {
            return legacyDirName;
        }

        @Override
        @NonNull
        public String dirNameFromLegacy(@NonNull AbstractFolder<I> parent, @NonNull String legacyDirName) {
            return legacyDirName;
        }

        @Override
        public void recordLegacyName(AbstractFolder<I> parent, I item, String legacyDirName) {
        }
    }
}

