// CHECKSTYLE:OFF

package com.cloudbees.hudson.plugins.folder;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Folder.DisplayName}: {@code Folder}.
     * 
     * @return
     *     {@code Folder}
     */
    public static String Folder_DisplayName() {
        return holder.format("Folder.DisplayName");
    }

    /**
     * Key {@code Folder.DisplayName}: {@code Folder}.
     * 
     * @return
     *     {@code Folder}
     */
    public static Localizable _Folder_DisplayName() {
        return new Localizable(holder, "Folder.DisplayName");
    }

    /**
     * Key {@code AbstractFolder.BeingDeleted}: {@code {0} is currently being
     * deleted}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is currently being deleted}
     */
    public static String AbstractFolder_BeingDeleted(Object arg0) {
        return holder.format("AbstractFolder.BeingDeleted", arg0);
    }

    /**
     * Key {@code AbstractFolder.BeingDeleted}: {@code {0} is currently being
     * deleted}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is currently being deleted}
     */
    public static Localizable _AbstractFolder_BeingDeleted(Object arg0) {
        return new Localizable(holder, "AbstractFolder.BeingDeleted", arg0);
    }

    /**
     * Key {@code RelocateAction.permission.desc}: {@code Required to move a
     * job from one folder (or Jenkins root) to another.}.
     * 
     * @return
     *     {@code Required to move a job from one folder (or Jenkins root) to
     *     another.}
     */
    public static String RelocateAction_permission_desc() {
        return holder.format("RelocateAction.permission.desc");
    }

    /**
     * Key {@code RelocateAction.permission.desc}: {@code Required to move a
     * job from one folder (or Jenkins root) to another.}.
     * 
     * @return
     *     {@code Required to move a job from one folder (or Jenkins root) to
     *     another.}
     */
    public static Localizable _RelocateAction_permission_desc() {
        return new Localizable(holder, "RelocateAction.permission.desc");
    }

    /**
     * Key {@code AbstractFolder.FailureToStopBuilds}: {@code Failed to
     * interrupt and stop {0,choice,1#{0,number,integer}
     * build|1<{0,number,integer} builds} of {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code Failed to interrupt and stop {0,choice,1#{0,number,integer}
     *     build|1<{0,number,integer} builds} of {1}}
     */
    public static String AbstractFolder_FailureToStopBuilds(Object arg0, Object arg1) {
        return holder.format("AbstractFolder.FailureToStopBuilds", arg0, arg1);
    }

    /**
     * Key {@code AbstractFolder.FailureToStopBuilds}: {@code Failed to
     * interrupt and stop {0,choice,1#{0,number,integer}
     * build|1<{0,number,integer} builds} of {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code Failed to interrupt and stop {0,choice,1#{0,number,integer}
     *     build|1<{0,number,integer} builds} of {1}}
     */
    public static Localizable _AbstractFolder_FailureToStopBuilds(Object arg0, Object arg1) {
        return new Localizable(holder, "AbstractFolder.FailureToStopBuilds", arg0, arg1);
    }

    /**
     * Key {@code Folder.DefaultPronoun}: {@code Item}.
     * 
     * @return
     *     {@code Item}
     */
    public static String Folder_DefaultPronoun() {
        return holder.format("Folder.DefaultPronoun");
    }

    /**
     * Key {@code Folder.DefaultPronoun}: {@code Item}.
     * 
     * @return
     *     {@code Item}
     */
    public static Localizable _Folder_DefaultPronoun() {
        return new Localizable(holder, "Folder.DefaultPronoun");
    }

    /**
     * Key {@code Folder.Description}: {@code Creates a container that stores
     * nested items in it. Useful for grouping things together. Unlike view,
     * which is just a filter, a folder creates a separate namespace, so you
     * can have multiple things of the same name as long as they are in
     * different folders.}.
     * 
     * @return
     *     {@code Creates a container that stores nested items in it. Useful for
     *     grouping things together. Unlike view, which is just a filter, a
     *     folder creates a separate namespace, so you can have multiple things
     *     of the same name as long as they are in different folders.}
     */
    public static String Folder_Description() {
        return holder.format("Folder.Description");
    }

    /**
     * Key {@code Folder.Description}: {@code Creates a container that stores
     * nested items in it. Useful for grouping things together. Unlike view,
     * which is just a filter, a folder creates a separate namespace, so you
     * can have multiple things of the same name as long as they are in
     * different folders.}.
     * 
     * @return
     *     {@code Creates a container that stores nested items in it. Useful for
     *     grouping things together. Unlike view, which is just a filter, a
     *     folder creates a separate namespace, so you can have multiple things
     *     of the same name as long as they are in different folders.}
     */
    public static Localizable _Folder_Description() {
        return new Localizable(holder, "Folder.Description");
    }

    /**
     * Key {@code RelocateAction.displayName}: {@code Move}.
     * 
     * @return
     *     {@code Move}
     */
    public static String RelocateAction_displayName() {
        return holder.format("RelocateAction.displayName");
    }

    /**
     * Key {@code RelocateAction.displayName}: {@code Move}.
     * 
     * @return
     *     {@code Move}
     */
    public static Localizable _RelocateAction_displayName() {
        return new Localizable(holder, "RelocateAction.displayName");
    }

}
