/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.relocate;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.relocate.RelocationHandler;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;

@Restricted(value={NoExternalUse.class})
@Extension(ordinal=-1000.0)
public final class StandardHandler
extends RelocationHandler {
    @Override
    public RelocationHandler.HandlingMode applicability(Item item) {
        if (item instanceof TopLevelItem && item instanceof AbstractItem && item.getParent() instanceof DirectlyModifiableTopLevelItemGroup && this.hasValidDestination(item)) {
            return RelocationHandler.HandlingMode.HANDLE;
        }
        return RelocationHandler.HandlingMode.SKIP;
    }

    @Override
    public HttpResponse handle(Item item, ItemGroup<?> destination, AtomicReference<Item> newItem, List<? extends RelocationHandler> chain) throws IOException, InterruptedException {
        if (!(destination instanceof DirectlyModifiableTopLevelItemGroup)) {
            return chain.isEmpty() ? null : chain.get(0).handle(item, destination, newItem, chain.subList(1, chain.size()));
        }
        Object result = StandardHandler.doMove(item, (DirectlyModifiableTopLevelItemGroup)destination);
        newItem.set((Item)result);
        return HttpResponses.redirectViaContextPath((String)(result.getParent().getUrl() + result.getShortUrl()));
    }

    private static <I extends AbstractItem> I doMove(Item item, DirectlyModifiableTopLevelItemGroup destination) throws IOException {
        return (I)Items.move((AbstractItem)((AbstractItem)item), (DirectlyModifiableTopLevelItemGroup)destination);
    }

    public boolean hasValidDestination(Item item) {
        Jenkins instance = Jenkins.getInstance();
        if (this.permitted(item, (DirectlyModifiableTopLevelItemGroup)instance) && instance.getItem(item.getName()) == null) {
            return true;
        }
        block0: for (Item g : Items.allItems((Authentication)ACL.SYSTEM, (ItemGroup)instance, Item.class)) {
            Folder folder;
            DirectlyModifiableTopLevelItemGroup itemGroup;
            if (!(g instanceof DirectlyModifiableTopLevelItemGroup) || !this.permitted(item, itemGroup = (DirectlyModifiableTopLevelItemGroup)g) || !g.hasPermission(Item.READ) || g == item || g instanceof Folder && (folder = (Folder)g).getItem(item.getName()) != null) continue;
            ItemGroup itemGroupSubElement = g.getParent();
            while (itemGroupSubElement != instance) {
                if (item == itemGroupSubElement || !(itemGroupSubElement instanceof Item)) continue block0;
                itemGroupSubElement = ((Item)itemGroupSubElement).getParent();
            }
            return true;
        }
        return false;
    }

    @Override
    public List<? extends ItemGroup<?>> validDestinations(Item item) {
        ArrayList<Object> result = new ArrayList<Object>();
        Jenkins instance = Jenkins.getInstance();
        if (this.permitted(item, (DirectlyModifiableTopLevelItemGroup)instance) && instance.getItem(item.getName()) == null || instance.getItem(item.getName()) == item) {
            result.add(instance);
        }
        block0: for (Item g : instance.getAllItems()) {
            Folder folder;
            DirectlyModifiableTopLevelItemGroup itemGroup;
            if (!(g instanceof DirectlyModifiableTopLevelItemGroup) || !this.permitted(item, itemGroup = (DirectlyModifiableTopLevelItemGroup)g) || g == item) continue;
            if (item.getParent() == g) {
                result.add(itemGroup);
            }
            if (g instanceof Folder && (folder = (Folder)g).getItem(item.getName()) != null) continue;
            ItemGroup itemGroupSubElement = g.getParent();
            while (itemGroupSubElement != instance) {
                if (item == itemGroupSubElement || !(itemGroupSubElement instanceof Item)) continue block0;
                itemGroupSubElement = ((Item)itemGroupSubElement).getParent();
            }
            result.add(itemGroup);
        }
        return result;
    }

    private boolean permitted(Item item, DirectlyModifiableTopLevelItemGroup itemGroup) {
        return itemGroup == item.getParent() || itemGroup.canAdd((TopLevelItem)item) && ((AccessControlled)itemGroup).hasPermission(Job.CREATE);
    }
}

