/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.config;

import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetric;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import hudson.Extension;
import hudson.model.Saveable;
import hudson.util.DescribableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
@Symbol(value={"defaultFolderConfiguration"})
public class AbstractFolderConfiguration
extends GlobalConfiguration {
    private List<FolderHealthMetric> healthMetrics;

    @Nonnull
    public static AbstractFolderConfiguration get() {
        AbstractFolderConfiguration instance = (AbstractFolderConfiguration)((Object)GlobalConfiguration.all().get(AbstractFolderConfiguration.class));
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    @DataBoundConstructor
    public AbstractFolderConfiguration() {
        this.load();
        if (this.healthMetrics == null) {
            ArrayList<FolderHealthMetric> metrics = new ArrayList<FolderHealthMetric>();
            for (FolderHealthMetricDescriptor d : FolderHealthMetricDescriptor.all()) {
                FolderHealthMetric metric = d.createDefault();
                if (metric == null) continue;
                metrics.add(metric);
            }
            this.healthMetrics = new DescribableList((Saveable)this, metrics);
        }
    }

    @Nonnull
    public List<FolderHealthMetric> getHealthMetrics() {
        return this.healthMetrics == null ? Collections.emptyList() : this.healthMetrics;
    }

    @DataBoundSetter
    public void setHealthMetrics(List<FolderHealthMetric> healthMetrics) {
        this.healthMetrics = healthMetrics;
        this.save();
    }
}

